/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import no.digipost.tuple.ViewableAsTuple;
import no.digipost.util.GetsNamedValue;
import no.digipost.util.SetsNamedValue;

public final class AttributesMap
implements Serializable {
    public static final AttributesMap EMPTY = AttributesMap.buildNew(new Config[0]).build();
    private static final Serializable NON_EXISTING_VALUE = new Serializable(){
        private static final long serialVersionUID = 1L;

        private Object readResolve() {
            return NON_EXISTING_VALUE;
        }

        public String toString() {
            return "[non-existing value]";
        }
    };
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> untypedMap;

    public static <V> Builder with(ViewableAsTuple<? extends SetsNamedValue<V>, V> attributeWithValue, Config ... configSwitches) {
        return AttributesMap.buildNew(configSwitches).and(attributeWithValue);
    }

    public static <V> Builder with(SetsNamedValue<V> attribute, V value, Config ... configSwitches) {
        return AttributesMap.buildNew(configSwitches).and(attribute, value);
    }

    public static Builder buildNew(Config ... configSwitches) {
        return new Builder(configSwitches);
    }

    private AttributesMap(Map<String, Object> untypedMap) {
        this.untypedMap = Collections.unmodifiableMap(untypedMap);
    }

    public <V> V get(GetsNamedValue<V> attribute) {
        Object value = attribute.requireFrom(this.untypedMap);
        return (V)(value != NON_EXISTING_VALUE ? value : null);
    }

    public int size() {
        return this.untypedMap.size();
    }

    public boolean isEmpty() {
        return this.untypedMap.isEmpty();
    }

    public String toString() {
        return this.untypedMap.isEmpty() ? "no attributes" : "attributes: " + this.untypedMap.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributesMap) {
            AttributesMap that = (AttributesMap)obj;
            return Objects.equals(this.untypedMap, that.untypedMap);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.untypedMap);
    }

    public static enum Config implements Supplier<Builder>
    {
        ALLOW_NULL_VALUES;


        @Override
        public Builder get() {
            return AttributesMap.buildNew(this);
        }
    }

    public static class Builder {
        private final ConcurrentMap<String, Object> incrementalMap = new ConcurrentHashMap<String, Object>();
        private final Set<Config> configSwitches;

        private Builder(Config ... configSwitches) {
            this.configSwitches = configSwitches.length == 0 ? EnumSet.noneOf(Config.class) : EnumSet.copyOf(Arrays.asList(configSwitches));
        }

        public <V> Builder and(ViewableAsTuple<? extends SetsNamedValue<V>, V> attributeWithValue) {
            return attributeWithValue.asTuple().to(this::and);
        }

        public <V> Builder and(SetsNamedValue<V> attribute, V value) {
            if (value != null || this.configSwitches.contains(Config.ALLOW_NULL_VALUES)) {
                attribute.setOn((name, v) -> this.incrementalMap.put((String)name, v != null ? v : NON_EXISTING_VALUE), value);
            }
            return this;
        }

        public Builder and(AttributesMap otherMap) {
            this.incrementalMap.putAll(otherMap.untypedMap);
            return this;
        }

        public Builder and(Builder otherBuilder) {
            this.incrementalMap.putAll(otherBuilder.incrementalMap);
            return this;
        }

        public AttributesMap build() {
            return new AttributesMap(this.incrementalMap);
        }
    }
}

