/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.util.bisect;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import no.digipost.function.ThrowingFunction;
import no.digipost.io.DataSize;

@FunctionalInterface
public interface Evaluator<T> {
    public static <T, U extends Comparable<? super U>, X extends Exception> Evaluator<T> having(ThrowingFunction<? super T, ? extends U, X> propertyExtractor, U comparableTarget) {
        return suggestion -> Result.fromComparatorResult(((Comparable)propertyExtractor.apply(suggestion)).compareTo(comparableTarget));
    }

    public static <T> Evaluator<T> size(DataSize targetSize, OutputStreamObjectWriter<? super T, ? super ByteCounter> serializer) {
        return Evaluator.byteCount(targetSize.toBytes(), serializer);
    }

    public static <T> Evaluator<T> byteCount(long targetBytes, OutputStreamObjectWriter<? super T, ? super ByteCounter> serializer) {
        return Evaluator.having(suggestion -> {
            ByteCounter counter = new ByteCounter();
            serializer.write(suggestion, counter);
            return counter.getByteCount();
        }, targetBytes);
    }

    public Result evaluate(T var1) throws Exception;

    @FunctionalInterface
    public static interface OutputStreamObjectWriter<T, O extends OutputStream> {
        public void write(T var1, O var2) throws Exception;
    }

    public static final class ByteCounter
    extends OutputStream {
        private long count;

        private ByteCounter() {
        }

        public long getByteCount() {
            return this.count;
        }

        @Override
        public void write(int b) {
            ++this.count;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            try {
                super.write(b, off, len);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void write(byte[] b) {
            try {
                super.write(b);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static enum Result {
        TOO_LOW,
        TOO_HIGH,
        FOUND;


        public static Result fromComparatorResult(int comparatorResult) {
            if (comparatorResult < 0) {
                return TOO_LOW;
            }
            if (comparatorResult > 0) {
                return TOO_HIGH;
            }
            return FOUND;
        }
    }
}

