/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DiggEnums {
    public static <E extends Enum<E>> Stream<E> fromCommaSeparatedNames(String enumNames, Class<E> enumType) {
        return DiggEnums.fromCommaSeparated(enumNames, Function.identity(), enumType);
    }

    public static <E extends Enum<E>> Stream<E> fromCommaSeparated(String enumsString, Function<String, String> toEnumName, Class<E> enumType) {
        return DiggEnums.fromEnumsString(enumsString, "\\s*,\\s*", toEnumName.andThen(e -> Enum.valueOf(enumType, e)));
    }

    public static <E extends Enum<E>> Stream<E> fromEnumsString(String enumsString, String delimRegex, Function<String, E> convertToEnum) {
        return DiggEnums.fromEnumsString(enumsString, delimRegex, e -> true, convertToEnum);
    }

    public static <E extends Enum<E>> Stream<E> fromEnumsString(String enumsString, String delimRegex, Predicate<String> included, Function<String, E> convertToEnum) {
        String trimmed = enumsString != null ? enumsString.trim() : "";
        return trimmed.isEmpty() ? Stream.empty() : Arrays.stream(trimmed.split(delimRegex)).filter(included).map(convertToEnum);
    }

    @SafeVarargs
    public static <E extends Enum<E>> String toCommaSeparatedNames(E ... enums) {
        return DiggEnums.toCommaSeparatedNames(Arrays.asList(enums));
    }

    public static <E extends Enum<E>> String toCommaSeparatedNames(Collection<E> enums) {
        return DiggEnums.toNames(",", enums);
    }

    @SafeVarargs
    public static <E extends Enum<E>> String toNames(String delim, E ... enums) {
        return DiggEnums.toNames(delim, Arrays.asList(enums));
    }

    public static <E extends Enum<E>> String toNames(String delim, Collection<E> enums) {
        return DiggEnums.toStringOf(Enum::name, delim, enums);
    }

    @SafeVarargs
    public static <E extends Enum<E>> String toStringOf(Function<? super E, String> enumAsString, String delim, E ... enums) {
        return DiggEnums.toStringOf(enumAsString, delim, Arrays.asList(enums));
    }

    public static <E extends Enum<E>> String toStringOf(Function<? super E, String> enumAsString, String delim, Collection<E> enums) {
        return DiggEnums.toStringOf(enumAsString, Collectors.joining(delim), enums);
    }

    @SafeVarargs
    public static <E extends Enum<E>> String toStringOf(Function<? super E, String> enumAsString, Collector<? super String, ?, String> joiner, E ... enums) {
        return DiggEnums.toStringOf(enumAsString, joiner, Arrays.asList(enums));
    }

    public static <E extends Enum<E>> String toStringOf(Function<? super E, String> enumAsString, Collector<? super String, ?, String> joiner, Collection<E> enums) {
        return enums.stream().map(enumAsString).collect(joiner);
    }

    private DiggEnums() {
    }
}

