/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.util.Collection;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import no.digipost.DiggBase;
import no.digipost.function.ObjIntFunction;
import no.digipost.function.ObjLongFunction;

public final class DiggStreams {
    public static final <S, V> Stream<V> streamByIntIndex(S source, int endExclusive, ObjIntFunction<S, V> resolveValue) {
        return DiggStreams.streamByIndex(source, IntStream.range(0, endExclusive), resolveValue);
    }

    public static final <S, K, V> Stream<V> streamByIndex(S source, IntStream indexes, ObjIntFunction<S, V> resolveValue) {
        return indexes.mapToObj(index -> resolveValue.apply(source, index));
    }

    public static final <S, V> Stream<V> streamByLongIndex(S source, long endExclusive, ObjLongFunction<S, V> resolveValue) {
        return DiggStreams.streamByIndex(source, LongStream.range(0L, endExclusive), resolveValue);
    }

    public static final <S, K, V> Stream<V> streamByIndex(S source, LongStream indexes, ObjLongFunction<S, V> resolveValue) {
        return indexes.mapToObj(index -> resolveValue.apply(source, index));
    }

    public static final <S, K, V> Stream<V> streamByKey(S source, Stream<K> keys, BiFunction<S, K, V> resolveValue) {
        return keys.map(key -> resolveValue.apply(source, key));
    }

    public static <E> Stream<E> streamWhileNonEmpty(IntFunction<? extends Collection<E>> resolveCollection) {
        return DiggStreams.streamPages(resolveCollection, c -> !c.isEmpty()).flatMap(Collection::stream);
    }

    public static <P> Stream<P> streamPages(IntFunction<P> resolvePage, Predicate<? super P> includeWhile) {
        return DiggStreams.streamPages(0, resolvePage, includeWhile);
    }

    public static <P> Stream<P> streamPages(final int firstPageNum, final IntFunction<P> resolvePage, final Predicate<? super P> includeWhile) {
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<P>(Long.MAX_VALUE, 0){
            final AtomicInteger pageNum;
            {
                super(arg0, arg1);
                this.pageNum = new AtomicInteger(firstPageNum);
            }

            @Override
            public boolean tryAdvance(Consumer<? super P> action) {
                Object nextPage = resolvePage.apply(this.pageNum.getAndIncrement());
                if (includeWhile.test(nextPage)) {
                    action.accept(nextPage);
                    return true;
                }
                return false;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public static String describeCharacteristics(Spliterator<?> spliterator) {
        int value = spliterator.characteristics();
        if (value == 0) {
            return DiggBase.friendlyName(spliterator.getClass()) + " with no enabled characteristics";
        }
        String enabledCharacteristics = Stream.of(spliterator.hasCharacteristics(64) ? "sized" : null, spliterator.hasCharacteristics(16384) ? "subsized" : null, spliterator.hasCharacteristics(1) ? "distinct" : null, spliterator.hasCharacteristics(256) ? "non-null" : null, spliterator.hasCharacteristics(1024) ? "immutable" : null, spliterator.hasCharacteristics(16) ? "ordered" : null, spliterator.hasCharacteristics(4096) ? "concurrent" : null, spliterator.hasCharacteristics(4) ? "sorted" : null).filter(Objects::nonNull).collect(Collectors.joining(", ", "", ""));
        return enabledCharacteristics + " " + DiggBase.friendlyName(spliterator.getClass()) + " (" + Integer.toBinaryString(value) + ")";
    }

    private DiggStreams() {
    }
}

