/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.function;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import no.digipost.DiggExceptions;

@FunctionalInterface
public interface ThrowingConsumer<T, X extends Throwable> {
    public void accept(T var1) throws X;

    default public Consumer<T> asUnchecked() {
        return this.ifException(DiggExceptions.rethrowAnyException);
    }

    default public Consumer<T> ifException(Consumer<Exception> exceptionHandler) {
        return this.ifException((? super T t, Exception e) -> exceptionHandler.accept((Exception)e));
    }

    default public Consumer<T> ifException(BiConsumer<? super T, Exception> exceptionHandler) {
        return t -> {
            try {
                this.accept(t);
            }
            catch (Exception e) {
                exceptionHandler.accept(t, e);
            }
            catch (Error err) {
                throw err;
            }
            catch (Throwable thr) {
                throw DiggExceptions.asUnchecked(thr);
            }
        };
    }

    default public ThrowingConsumer<T, X> andThen(ThrowingConsumer<? super T, ? extends X> after) {
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }
}

