/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import no.digipost.DiggBase;
import no.digipost.DiggExceptions;
import no.digipost.io.DataSize;

public class InputStreamIterator
implements Iterator<byte[]> {
    private final InputStream inputStream;
    private final int chunkSizeBytes;
    private byte[] next;
    private Boolean hasNext;

    public InputStreamIterator(InputStream inputStream, DataSize chunkSize) {
        this(inputStream, Math.toIntExact(chunkSize.toBytes()));
    }

    public InputStreamIterator(InputStream inputStream, int chunkSizeBytes) {
        this.inputStream = inputStream;
        this.chunkSizeBytes = chunkSizeBytes;
    }

    private byte[] loadNextChunk() {
        byte[] chunk = new byte[this.chunkSizeBytes];
        int bytesRead = 0;
        try {
            bytesRead = this.inputStream.read(chunk);
            if (bytesRead == -1) {
                return null;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed reading next chunk of up to " + this.chunkSizeBytes + " bytes from " + DiggBase.friendlyName(this.inputStream.getClass()) + " because " + DiggExceptions.exceptionNameAndMessage(e), e);
        }
        if (bytesRead < this.chunkSizeBytes) {
            byte[] smallerBuffer = new byte[bytesRead];
            System.arraycopy(chunk, 0, smallerBuffer, 0, bytesRead);
            chunk = smallerBuffer;
        }
        return chunk;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext == null) {
            this.next = this.loadNextChunk();
            this.hasNext = this.next != null;
        }
        return this.hasNext;
    }

    @Override
    public byte[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more data to read");
        }
        byte[] result = this.next;
        this.hasNext = null;
        this.next = null;
        return result;
    }
}

