/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Optional;
import no.digipost.jdbc.BasicColumnMapper;
import no.digipost.jdbc.NullableColumnMapper;
import no.digipost.jdbc.SqlArray;

public final class Mappers {
    public static final BasicColumnMapper<Boolean> getBoolean = (name, rs) -> {
        boolean value = rs.getBoolean(name);
        return rs.wasNull() ? null : Boolean.valueOf(value);
    };
    public static final NullableColumnMapper<Boolean> getNullableBoolean = (name, rs) -> {
        boolean value = rs.getBoolean(name);
        return rs.wasNull() ? Optional.empty() : Optional.of(value);
    };
    public static final BasicColumnMapper<Byte> getByte = (name, rs) -> {
        byte value = rs.getByte(name);
        return rs.wasNull() ? null : Byte.valueOf(value);
    };
    public static final NullableColumnMapper<Byte> getNullableByte = (name, rs) -> {
        byte value = rs.getByte(name);
        return rs.wasNull() ? Optional.empty() : Optional.of(value);
    };
    public static final BasicColumnMapper<Short> getShort = (name, rs) -> {
        short value = rs.getShort(name);
        return rs.wasNull() ? null : Short.valueOf(value);
    };
    public static final NullableColumnMapper<Short> getNullableShort = (name, rs) -> {
        short value = rs.getShort(name);
        return rs.wasNull() ? Optional.empty() : Optional.of(value);
    };
    public static final BasicColumnMapper<Integer> getInt = (name, rs) -> {
        int value = rs.getInt(name);
        return rs.wasNull() ? null : Integer.valueOf(value);
    };
    public static final NullableColumnMapper<Integer> getNullableInt = (name, rs) -> {
        int value = rs.getInt(name);
        return rs.wasNull() ? Optional.empty() : Optional.of(value);
    };
    public static final BasicColumnMapper<Long> getLong = (name, rs) -> {
        long value = rs.getLong(name);
        return rs.wasNull() ? null : Long.valueOf(value);
    };
    public static final NullableColumnMapper<Long> getNullableLong = (name, rs) -> {
        long value = rs.getLong(name);
        return rs.wasNull() ? Optional.empty() : Optional.of(value);
    };
    public static final BasicColumnMapper<Float> getFloat = (name, rs) -> {
        float value = rs.getFloat(name);
        return rs.wasNull() ? null : Float.valueOf(value);
    };
    public static final NullableColumnMapper<Float> getNullableFloat = (name, rs) -> {
        float value = rs.getFloat(name);
        return rs.wasNull() ? Optional.empty() : Optional.of(Float.valueOf(value));
    };
    public static final BasicColumnMapper<Double> getDouble = (name, rs) -> {
        double value = rs.getDouble(name);
        return rs.wasNull() ? null : Double.valueOf(value);
    };
    public static final NullableColumnMapper<Double> getNullableDouble = (name, rs) -> {
        double value = rs.getDouble(name);
        return rs.wasNull() ? Optional.empty() : Optional.of(value);
    };
    public static final BasicColumnMapper<BigDecimal> getBigDecimal = (name, rs) -> rs.getBigDecimal(name);
    public static final NullableColumnMapper<BigDecimal> getNullableBigDecimal = (name, rs) -> Optional.ofNullable(rs.getBigDecimal(name));
    public static final BasicColumnMapper<byte[]> getBytes = (name, rs) -> rs.getBytes(name);
    public static final NullableColumnMapper<byte[]> getNullableBytes = (name, rs) -> Optional.ofNullable(rs.getBytes(name));
    public static final BasicColumnMapper<String> getString = (name, rs) -> rs.getString(name);
    public static final NullableColumnMapper<String> getNullableString = (name, rs) -> Optional.ofNullable(rs.getString(name));
    public static final BasicColumnMapper<URL> getURL = (name, rs) -> rs.getURL(name);
    public static final NullableColumnMapper<URL> getNullableURL = (name, rs) -> Optional.ofNullable(rs.getURL(name));
    public static final BasicColumnMapper<Date> getDate = (name, rs) -> rs.getDate(name);
    public static final NullableColumnMapper<Date> getNullableDate = (name, rs) -> Optional.ofNullable(rs.getDate(name));
    public static final BasicColumnMapper<Timestamp> getTimestamp = (name, rs) -> rs.getTimestamp(name);
    public static final NullableColumnMapper<Timestamp> getNullableTimestamp = (name, rs) -> Optional.ofNullable(rs.getTimestamp(name));
    public static final BasicColumnMapper<Instant> getInstant = getTimestamp.nullFallthrough().andThen(Timestamp::toInstant);
    public static final NullableColumnMapper<Instant> getNullableInstant = getNullableTimestamp.andThen(Timestamp::toInstant);
    public static final BasicColumnMapper<InputStream> getAsciiStream = (name, rs) -> rs.getAsciiStream(name);
    public static final NullableColumnMapper<InputStream> getNullableAsciiStream = (name, rs) -> Optional.ofNullable(rs.getAsciiStream(name));
    public static final BasicColumnMapper<InputStream> getBinaryStream = (name, rs) -> rs.getBinaryStream(name);
    public static final NullableColumnMapper<InputStream> getNullableBinaryStream = (name, rs) -> Optional.ofNullable(rs.getBinaryStream(name));
    public static final BasicColumnMapper<Reader> getCharacterStream = (name, rs) -> rs.getCharacterStream(name);
    public static final NullableColumnMapper<Reader> getNullableCharacterStream = (name, rs) -> Optional.ofNullable(rs.getCharacterStream(name));
    public static final BasicColumnMapper<Array> getSqlArray = (name, rs) -> rs.getArray(name);
    public static final BasicColumnMapper<Object> getArray = (name, rs) -> ((SqlArray)getSqlArray.andThen(SqlArray::of).map(name, rs)).consume(a -> a != null ? a.getArray() : null);
    public static final BasicColumnMapper<String[]> getStringArray = getArray.andThen(String[].class::cast);
    public static final BasicColumnMapper<int[]> getIntArray = getArray.andThen(int[].class::cast);
    public static final BasicColumnMapper<long[]> getLongArray = getArray.andThen(long[].class::cast);

    private Mappers() {
    }
}

