/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.util.bisect;

public final class Suggestion<T>
implements AutoCloseable {
    private final T value;
    private final Disposer<? super T> disposer;
    private boolean accepted = false;

    public static <T> Suggestion<T> of(T value) {
        if (value instanceof AutoCloseable) {
            Suggestion<AutoCloseable> suggestionDisposedByClosing = Suggestion.of((AutoCloseable)value);
            return suggestionDisposedByClosing;
        }
        return Suggestion.of(value, Disposer.NO_DISPOSING);
    }

    public static <T extends AutoCloseable> Suggestion<T> of(T value) {
        return new Suggestion<AutoCloseable>(value, Disposer.DISPOSE_BY_CLOSING);
    }

    public static <T> Suggestion<T> of(T value, Disposer<? super T> dismissedSuggestionDisposer) {
        return new Suggestion<T>(value, dismissedSuggestionDisposer);
    }

    private Suggestion(T value, Disposer<? super T> disposer) {
        this.value = value;
        this.disposer = disposer;
    }

    T peek() {
        return this.value;
    }

    T accepted() {
        this.accepted = true;
        return this.value;
    }

    @Override
    public void close() throws Exception {
        if (!this.accepted) {
            this.disposer.dispose(this.value);
        }
    }

    @FunctionalInterface
    public static interface Disposer<T> {
        public static final Disposer<Object> NO_DISPOSING = suggestion -> {};
        public static final Disposer<AutoCloseable> DISPOSE_BY_CLOSING = AutoCloseable::close;

        public void dispose(T var1) throws Exception;
    }
}

