/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import no.digipost.DiggOptionals;
import no.digipost.collection.AdaptableCollector;
import no.digipost.collection.EnforceAtMostOneElementCollector;
import no.digipost.concurrent.OneTimeAssignment;
import no.digipost.tuple.Tuple;
import no.digipost.tuple.ViewableAsTuple;
import no.digipost.util.ViewableAsOptional;

public final class DiggCollectors {
    public static <T1, T2> AdaptableCollector<ViewableAsTuple<T1, Optional<T2>>, ?, Map<T1, List<T2>>> toMultimap() {
        Function<ViewableAsTuple, Tuple> asTuple = ViewableAsTuple::asTuple;
        return DiggCollectors.toMultimap(asTuple.andThen(Tuple::first), asTuple.andThen(Tuple::second));
    }

    public static <T, V> AdaptableCollector<T, ?, Map<T, List<V>>> toMultimap(Function<? super T, Optional<V>> extractor) {
        return DiggCollectors.toMultimap(Function.identity(), extractor);
    }

    public static <T, K, V> AdaptableCollector<T, ?, Map<K, List<V>>> toMultimap(Function<? super T, K> keyExtractor, Function<? super T, Optional<V>> extractor) {
        return DiggCollectors.adapt(Collectors.toMap(keyExtractor, extractor.andThen(DiggOptionals::toList), DiggCollectors::concat));
    }

    public static <T> AdaptableCollector<T, OneTimeAssignment<T>, Optional<T>> allowAtMostOne() {
        return DiggCollectors.allowAtMostOneOrElseThrow(ViewableAsOptional.TooManyElements::new);
    }

    public static <T> AdaptableCollector<T, OneTimeAssignment<T>, Optional<T>> allowAtMostOneOrElseThrow(BiFunction<? super T, ? super T, ? extends RuntimeException> exceptionOnExcessiveElements) {
        return DiggCollectors.adapt(new EnforceAtMostOneElementCollector<T>(exceptionOnExcessiveElements));
    }

    @Deprecated
    public static <T, A, R> AdaptableCollector<T, A, R> adapt(Collector<T, A, R> collector) {
        if (collector instanceof AdaptableCollector) {
            return (AdaptableCollector)collector;
        }
        return AdaptableCollector.of(collector.supplier(), collector.accumulator(), collector.combiner(), collector.finisher(), collector.characteristics());
    }

    private static <T> List<T> concat(Collection<? extends T> list1, Collection<? extends T> list2) {
        ArrayList<T> newList = new ArrayList<T>(list1.size() + list2.size());
        newList.addAll(list1);
        newList.addAll(list2);
        return Collections.unmodifiableList(newList);
    }

    private DiggCollectors() {
    }
}

