/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.collection;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import no.digipost.concurrent.OneTimeAssignment;
import no.digipost.util.ViewableAsOptional;

public class EnforceAtMostOneElementCollector<T>
implements Collector<T, OneTimeAssignment<T>, Optional<T>> {
    private static final Set<Collector.Characteristics> CHARACTERISTICS = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT));
    private final BiFunction<? super T, ? super T, ? extends RuntimeException> exceptionOnExcessiveElements;

    public EnforceAtMostOneElementCollector(BiFunction<? super T, ? super T, ? extends RuntimeException> exceptionOnExcessiveElements) {
        this.exceptionOnExcessiveElements = exceptionOnExcessiveElements;
    }

    @Override
    public Supplier<OneTimeAssignment<T>> supplier() {
        return OneTimeAssignment::newInstance;
    }

    @Override
    public BiConsumer<OneTimeAssignment<T>, T> accumulator() {
        return this::trySet;
    }

    @Override
    public BinaryOperator<OneTimeAssignment<T>> combiner() {
        return (a1, a2) -> {
            Object a2Value = a2.get();
            if (a2Value != null) {
                this.trySet((OneTimeAssignment<T>)a1, (T)a2Value);
            }
            return a1;
        };
    }

    @Override
    public Function<OneTimeAssignment<T>, Optional<T>> finisher() {
        return ViewableAsOptional::toOptional;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return CHARACTERISTICS;
    }

    private void trySet(OneTimeAssignment<T> ref, T value) {
        try {
            ref.set(value);
        }
        catch (OneTimeAssignment.AlreadyAssigned e) {
            RuntimeException tooManyElements = this.exceptionOnExcessiveElements.apply(ref.get(), value);
            tooManyElements.addSuppressed(e);
            throw tooManyElements;
        }
    }
}

