/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import no.digipost.DiggExceptions;

public abstract class SimpleIterator<T>
implements Iterator<T> {
    private Optional<? extends T> next = Optional.empty();

    protected abstract Optional<? extends T> nextIfAvailable() throws Exception;

    @Override
    public final boolean hasNext() {
        try {
            this.next = this.nextIfAvailable();
        }
        catch (Exception e) {
            throw DiggExceptions.asUnchecked(e);
        }
        return this.next.isPresent();
    }

    @Override
    public final T next() {
        if (!this.next.isPresent() && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        T toReturn = this.next.get();
        this.next = Optional.empty();
        return toReturn;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported");
    }
}

