/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.function;

import java.util.function.BiFunction;
import no.digipost.DiggExceptions;
import no.digipost.function.ThrowingFunction;

@FunctionalInterface
public interface ThrowingBiFunction<T, U, R, X extends Throwable> {
    public R apply(T var1, U var2) throws X;

    default public BiFunction<T, U, R> asUnchecked() {
        return (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw DiggExceptions.asUnchecked(e);
            }
        };
    }

    default public <V> ThrowingBiFunction<T, U, V, X> andThen(ThrowingFunction<? super R, V, ? extends X> after) {
        return (t, u) -> after.apply((R)this.apply(t, u));
    }
}

