/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.function;

import java.util.function.Consumer;
import java.util.function.Function;
import no.digipost.DiggExceptions;

@FunctionalInterface
public interface ThrowingRunnable<X extends Throwable> {
    public void run() throws X;

    default public Runnable asUnchecked() {
        return this.ifExceptionThrow(DiggExceptions::asUnchecked);
    }

    default public Runnable ifExceptionThrow(Function<? super Exception, ? extends RuntimeException> exceptionMapper) {
        return this.ifException(e -> {
            throw (RuntimeException)exceptionMapper.apply((Exception)e);
        });
    }

    default public Runnable ifException(Consumer<Exception> exceptionHandler) {
        return () -> {
            try {
                this.run();
            }
            catch (Exception e) {
                exceptionHandler.accept(e);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw DiggExceptions.asUnchecked(e);
            }
        };
    }
}

