/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import no.digipost.DiggExceptions;
import no.digipost.jdbc.AttributeMapper;
import no.digipost.jdbc.RowMapper;
import no.digipost.util.AttributesMap;

public class AttributesRowMapper
implements RowMapper<AttributesMap> {
    private final Supplier<AttributesMap.Builder> attributeMapBuilderSupplier;
    private final Map<String, ? extends AttributeMapper<?>> mappers;

    public AttributesRowMapper(AttributeMapper<?> ... mappers) {
        this(() -> AttributesMap.buildNew(new AttributesMap.Config[0]), mappers);
    }

    public AttributesRowMapper(Supplier<AttributesMap.Builder> attributeMapBuilderSupplier, AttributeMapper<?> ... mappers) {
        this(attributeMapBuilderSupplier, Stream.of(mappers));
    }

    public AttributesRowMapper(Stream<AttributeMapper<?>> mappers) {
        this(() -> AttributesMap.buildNew(new AttributesMap.Config[0]), mappers);
    }

    public AttributesRowMapper(Supplier<AttributesMap.Builder> attributeMapBuilderSupplier, Stream<AttributeMapper<?>> mappers) {
        this.attributeMapBuilderSupplier = attributeMapBuilderSupplier;
        this.mappers = mappers.collect(Collectors.toMap(AttributeMapper::getAttributeName, Function.identity()));
    }

    @Override
    public AttributesMap fromResultSet(ResultSet rs, int rowNum) throws SQLException {
        AttributesMap.Builder attributes = this.attributeMapBuilderSupplier.get();
        for (AttributeMapper mapper : this.applicableMappers(rs.getMetaData()).collect(Collectors.toList())) {
            attributes.and(mapper.attributeAndValue(rs));
        }
        return attributes.build();
    }

    private Stream<AttributeMapper<?>> applicableMappers(ResultSetMetaData metadata) throws SQLException {
        return IntStream.rangeClosed(1, metadata.getColumnCount()).limit(metadata.getColumnCount()).mapToObj(i -> {
            try {
                return metadata.getColumnLabel(i);
            }
            catch (SQLException e) {
                throw DiggExceptions.asUnchecked(e);
            }
        }).filter(this.mappers::containsKey).map(this.mappers::get);
    }
}

