/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.BiFunction;
import java.util.function.Function;
import no.digipost.function.QuadFunction;
import no.digipost.function.ThrowingFunction;
import no.digipost.function.TriFunction;
import no.digipost.tuple.Tuple;

@FunctionalInterface
public interface RowMapper<R> {
    public static <R> RowMapper<R> of(ThrowingFunction<ResultSet, R, SQLException> mapper) {
        return RowMapper.of((ResultSet rs, int n) -> mapper.apply(rs));
    }

    public static <R> RowMapper<R> of(RowMapper<R> mapper) {
        return mapper;
    }

    public R fromResultSet(ResultSet var1, int var2) throws SQLException;

    default public R fromResultSet(ResultSet resultSet) throws SQLException {
        return this.fromResultSet(resultSet, resultSet.getRow());
    }

    default public <S> Tupled<R, S> combinedWith(RowMapper<S> otherMapper) {
        return (rs, n) -> Tuple.of(this.fromResultSet(rs, n), otherMapper.fromResultSet(rs, n));
    }

    default public <S> RowMapper<S> andThen(Function<? super R, S> resultMapper) {
        return (rs, n) -> resultMapper.apply((R)this.fromResultSet(rs, n));
    }

    public static interface Quadrupled<T, U, V, W>
    extends Tripled<Tuple<T, U>, V, W> {
        default public <S> RowMapper<S> andThen(QuadFunction<? super T, ? super U, ? super V, ? super W, S> mapper) {
            return this.andThen((? super R tuvw) -> {
                Tuple tuv = (Tuple)tuvw.first();
                Tuple tu = (Tuple)tuv.first();
                return mapper.apply((Object)tu.first(), (Object)tu.second(), (Object)tuv.second(), (Object)tuvw.second());
            });
        }
    }

    public static interface Tripled<T, U, V>
    extends Tupled<Tuple<T, U>, V> {
        default public <W> Quadrupled<T, U, V, W> combinedWith(RowMapper<W> otherMapper) {
            return (rs, n) -> Tuple.of(this.fromResultSet(rs, n), otherMapper.fromResultSet(rs, n));
        }

        default public <S> RowMapper<S> andThen(TriFunction<? super T, ? super U, ? super V, S> resultMapper) {
            return this.andThen((? super R tuv) -> {
                Tuple tu = (Tuple)tuv.first();
                return resultMapper.apply((Object)tu.first(), (Object)tu.second(), (Object)tuv.second());
            });
        }
    }

    public static interface Tupled<T, U>
    extends RowMapper<Tuple<T, U>> {
        default public <V> Tripled<T, U, V> combinedWith(RowMapper<V> otherMapper) {
            return (rs, n) -> Tuple.of(this.fromResultSet(rs, n), otherMapper.fromResultSet(rs, n));
        }

        default public <S> RowMapper<S> andThen(BiFunction<? super T, ? super U, S> resultMapper) {
            return this.andThen((? super R tu) -> resultMapper.apply((Object)tu.first(), (Object)tu.second()));
        }
    }
}

