/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import no.digipost.time.TimeControllable;

public final class ControllableClock
extends Clock
implements TimeControllable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final AtomicReference<Clock> delegate;

    public ControllableClock(Instant fixedNow) {
        this(fixedNow, ZoneId.systemDefault());
    }

    public ControllableClock(LocalDateTime fixedNow) {
        this(fixedNow.atZone(ZoneId.systemDefault()));
    }

    public ControllableClock(ZonedDateTime fixedNow) {
        this(fixedNow.toInstant(), fixedNow.getZone());
    }

    public ControllableClock(Instant fixedNow, ZoneId zone) {
        this(Clock.fixed(fixedNow, zone));
    }

    public ControllableClock(Clock delegate) {
        this.delegate = new AtomicReference<Clock>(delegate);
    }

    @Override
    public ZoneId getZone() {
        return this.delegate.get().getZone();
    }

    @Override
    public ControllableClock withZone(ZoneId zone) {
        return new ControllableClock(this.delegate.get().withZone(zone));
    }

    @Override
    public Instant instant() {
        return this.delegate.get().instant();
    }

    @Override
    public void timePasses(Duration duration) {
        this.delegate.getAndUpdate(previous -> Clock.offset(previous, duration));
    }

    @Override
    public void set(LocalDateTime dateTime) {
        this.set(dateTime.atZone(this.getZone()));
    }

    @Override
    public void set(Instant newInstant) {
        this.delegate.getAndUpdate(previous -> Clock.offset(previous, Duration.between(previous.instant(), newInstant)));
    }

    public void set(Clock newDelegate) {
        if (this.equals(newDelegate)) {
            throw new IllegalArgumentException("Cycle detected! Tried to set " + this + " with same instance as itself!");
        }
        this.delegate.set(newDelegate);
    }

    @Override
    public void freeze() {
        this.set(Clock.fixed(this.delegate.get().instant(), this.delegate.get().getZone()));
    }

    @Override
    public void setToSystemClock() {
        this.setToSystemClock(this.getZone());
    }

    public void setToSystemClock(ZoneId zoneId) {
        this.set(Clock.system(zoneId));
    }

    public String toString() {
        return "Controllable " + this.delegate.get();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ControllableClock) {
            ControllableClock that = (ControllableClock)obj;
            return Objects.equals(this.delegate.get(), that.delegate.get());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.delegate.get());
    }
}

