/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.tuple;

import java.io.Serializable;
import java.util.function.Function;
import no.digipost.tuple.Tuple;
import no.digipost.tuple.ViewableAsTriple;
import no.digipost.tuple.XTuple;

public interface Triple<T1, T2, T3>
extends ViewableAsTriple<T1, T2, T3> {
    public static <T1, T2, T3> Triple<T1, T2, T3> of(T1 first, T2 second, T3 third) {
        return new XTuple<T1, T2, T3, Serializable>(first, second, third, XTuple.TERMINATOR);
    }

    public static <T1, T2, T3> Triple<T1, T2, T3> flatten(Tuple<Tuple<T1, T2>, T3> nestedTuple) {
        return Triple.of(nestedTuple.first().first(), nestedTuple.first().second(), nestedTuple.second());
    }

    public T1 first();

    public T2 second();

    public T3 third();

    public <S1> Triple<S1, T2, T3> mapFirst(Function<? super T1, ? extends S1> var1);

    public <S2> Triple<T1, S2, T3> mapSecond(Function<? super T2, ? extends S2> var1);

    public <S3> Triple<T1, T2, S3> mapThird(Function<? super T3, ? extends S3> var1);

    public <S1, S2, S3> Triple<S1, S2, S3> map(Function<? super T1, ? extends S1> var1, Function<? super T2, ? extends S2> var2, Function<? super T3, ? extends S3> var3);

    @Override
    public Triple<T1, T2, T3> asTriple();
}

