/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.tuple;

import java.io.Serializable;
import java.util.function.Function;
import no.digipost.tuple.ViewableAsTuple;
import no.digipost.tuple.XTuple;

public interface Tuple<T1, T2>
extends ViewableAsTuple<T1, T2> {
    public static <T1, T2> Tuple<T1, T2> of(T1 first, T2 second) {
        return new XTuple<T1, T2, Serializable, Object>(first, second, XTuple.TERMINATOR, null);
    }

    public T1 first();

    public T2 second();

    public <S1> Tuple<S1, T2> mapFirst(Function<? super T1, ? extends S1> var1);

    public <S2> Tuple<T1, S2> mapSecond(Function<? super T2, ? extends S2> var1);

    public <S1, S2> Tuple<S1, S2> map(Function<? super T1, ? extends S1> var1, Function<? super T2, ? extends S2> var2);

    default public Tuple<T2, T1> swap() {
        return Tuple.of(this.second(), this.first());
    }

    @Override
    public Tuple<T1, T2> asTuple();
}

