/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class DiggBase {
    public static <T> T nonNull(String description, T t) {
        return (T)DiggBase.nonNull(description, (? super String d) -> t);
    }

    public static <T, X extends Throwable> T nonNull(String description, T t, Function<? super String, X> throwIfNull) throws X {
        return DiggBase.nonNull(t, () -> (Throwable)throwIfNull.apply(description + " can not be null"));
    }

    public static <T, X extends Throwable> T nonNull(T t, Supplier<X> throwIfNull) throws X {
        return (T)DiggBase.nonNull("a reference", s -> t, (? super String s) -> (Throwable)throwIfNull.get());
    }

    public static <T> T nonNull(String descriptiveRefKey, Function<? super String, T> refResolver) {
        return DiggBase.nonNull(descriptiveRefKey, refResolver, (? super String d) -> new NullPointerException("Tried to resolve " + d + ", but got null!"));
    }

    public static <T, X extends Throwable> T nonNull(String descriptiveRefKey, Function<? super String, T> refResolver, Function<? super String, X> throwIfNull) throws X {
        T ref = refResolver.apply(descriptiveRefKey);
        if (ref != null) {
            return ref;
        }
        throw (Throwable)throwIfNull.apply(descriptiveRefKey);
    }

    public static String friendlyName(Class<?> clazz) {
        ArrayDeque classes = new ArrayDeque();
        classes.add(clazz);
        for (Class<?> enclosing = clazz.getEnclosingClass(); enclosing != null; enclosing = enclosing.getEnclosingClass()) {
            classes.add(enclosing);
        }
        return StreamSupport.stream(Spliterators.spliterator(classes.descendingIterator(), (long)classes.size(), 16), false).map(Class::getSimpleName).collect(Collectors.joining("."));
    }

    @SafeVarargs
    public static final <T, R> Stream<R> extract(T object, Function<? super T, ? extends R> ... extractors) {
        return Stream.of(extractors).map(e -> e.apply(object));
    }

    @SafeVarargs
    public static final <T, R> Stream<R> extractIfPresent(T object, Function<? super T, ? extends Optional<R>> ... extractors) {
        return DiggBase.extract(object, extractors).filter(Optional::isPresent).map(Optional::get);
    }

    private DiggBase() {
    }
}

