/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DiggOptionals {
    @SafeVarargs
    public static <T> Stream<T> toStream(Optional<T> ... optionals) {
        return Stream.of(optionals).filter(Optional::isPresent).map(Optional::get);
    }

    public static <T> List<T> toList(Optional<T> optional) {
        return Collections.unmodifiableList(DiggOptionals.collect(optional, Collectors.toCollection(() -> new ArrayList(1))));
    }

    public static <T, A, R> R collect(Optional<T> optional, Collector<T, A, R> collector) {
        Object container = collector.supplier().get();
        optional.ifPresent(o -> collector.accumulator().accept(container, o));
        return collector.finisher().apply(container);
    }
}

