/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.concurrent;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;

@FunctionalInterface
public interface TargetState {
    public static final TargetState IMMEDIATELY = () -> true;
    public static final TargetState NEVER = () -> false;

    public boolean yet();

    default public void untilThen(Supplier<TaskControl> loopingTask, Consumer<? super Exception> exceptionHandler) {
        while (!this.yet()) {
            try {
                TaskControl taskControl = loopingTask.get();
                if (taskControl == TaskControl.EXIT) {
                    return;
                }
                if (taskControl == TaskControl.TRY_REPEAT) continue;
                throw new IllegalStateException("'" + (Object)((Object)taskControl) + "' is not a valid " + TaskControl.class.getSimpleName() + ". " + "The loopingTask must return either " + (Object)((Object)TaskControl.TRY_REPEAT) + " or " + (Object)((Object)TaskControl.EXIT) + " to control the looping behavior.");
            }
            catch (Exception e) {
                exceptionHandler.accept(e);
            }
        }
    }

    default public void untilThen(Runnable loopingTask, Consumer<? super Exception> exceptionHandler) {
        this.untilThen(() -> {
            loopingTask.run();
            return TaskControl.TRY_REPEAT;
        }, exceptionHandler);
    }

    default public TargetState or(TargetState that) {
        return () -> this.yet() || that.yet();
    }

    public static TargetState all(TargetState ... states) {
        return TargetState.all(Arrays.asList(states));
    }

    public static TargetState all(Iterable<? extends TargetState> states) {
        return () -> {
            for (TargetState state : states) {
                if (state.yet()) continue;
                return false;
            }
            return true;
        };
    }

    public static enum TaskControl {
        TRY_REPEAT,
        EXIT;

    }
}

