/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.async;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.Logger;

class AsyncUpdater
implements Runnable {
    private static final Logger LOG = Logger.getLogger(AsyncUpdater.class.getName());
    private final Runnable updateNewValues;
    private final Duration updateInterval;
    private Clock clock;
    private String updaterName;
    private Instant lastUpdate;
    private boolean lastUpdateSuccessful;

    AsyncUpdater(Clock clock, String updaterName, Runnable updateNewValues, Duration updateInterval) {
        this.clock = clock;
        this.updaterName = updaterName;
        this.updateNewValues = updateNewValues;
        this.updateInterval = updateInterval;
        this.lastUpdate = clock.instant();
        this.lastUpdateSuccessful = true;
    }

    @Override
    public void run() {
        try {
            this.updateNewValues.run();
            this.lastUpdate = this.clock.instant();
            this.lastUpdateSuccessful = true;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unexpected exception in updater '" + this.updaterName + "' while updating metrics.", e);
            this.lastUpdateSuccessful = false;
        }
    }

    boolean isStale() {
        Duration sinceLastUpdate = Duration.between(this.lastUpdate, this.clock.instant());
        return sinceLastUpdate.toMillis() > 2L * this.updateInterval.toMillis();
    }

    boolean isFailing() {
        return !this.lastUpdateSuccessful;
    }

    public String getName() {
        return this.updaterName;
    }

    public Instant getLastUpdate() {
        return this.lastUpdate;
    }
}

