/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.async;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import no.digipost.DiggConcurrent;
import no.digipost.monitoring.async.AsyncUpdater;

public class MetricsUpdater {
    private static final Logger LOG = Logger.getLogger(MetricsUpdater.class.getName());
    final List<AsyncUpdater> updaters = new ArrayList<AsyncUpdater>();
    private ScheduledExecutorService scheduledExecutor;
    private Clock clock;

    public MetricsUpdater(MeterRegistry registry, int maxThreads) {
        this(registry, maxThreads, "app_async_update_scrape_errors");
    }

    public MetricsUpdater(MeterRegistry registry, int maxThreads, String scrapeErrorsMetricName) {
        this(registry, Executors.newScheduledThreadPool(maxThreads, DiggConcurrent.threadNamingFactory((String)"micrometer-metrics-updater")), scrapeErrorsMetricName, Clock.systemDefaultZone());
    }

    MetricsUpdater(MeterRegistry registry, ScheduledExecutorService scheduledExecutor, String scrapeErrorsMetricName, Clock clock) {
        this.clock = clock;
        this.scheduledExecutor = scheduledExecutor;
        Gauge.builder((String)scrapeErrorsMetricName, this::getScrapeErrors).register(registry);
    }

    double getScrapeErrors() {
        AtomicInteger errors = new AtomicInteger(0);
        StringBuilder warnings = new StringBuilder();
        this.updaters.forEach(u -> {
            if (u.isStale()) {
                errors.incrementAndGet();
                warnings.append("AsyncUpdater '" + u.getName() + "' has not run since " + u.getLastUpdate()).append("\n");
            }
            if (u.isFailing()) {
                errors.incrementAndGet();
                warnings.append("AsyncUpdater '" + u.getName() + "' did not run successfully last time.").append("\n");
            }
        });
        if (errors.get() > 0) {
            LOG.warning(warnings.toString());
        }
        return errors.get();
    }

    public void stop() {
        DiggConcurrent.ensureShutdown((ExecutorService)this.scheduledExecutor, (Duration)Duration.ofSeconds(30L));
    }

    public void registerAsyncUpdate(String updaterName, Duration updateInterval, Runnable setNewValues) {
        AsyncUpdater asyncUpdater = new AsyncUpdater(this.clock, updaterName, setNewValues, updateInterval);
        this.updaters.add(asyncUpdater);
        this.scheduledExecutor.scheduleAtFixedRate(asyncUpdater, 0L, updateInterval.toMillis(), TimeUnit.MILLISECONDS);
    }
}

