/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import no.digipost.monitoring.db.DbStatus;
import no.digipost.monitoring.db.DbStatusCollector;

public class MasterDbStatusCollector
implements DbStatusCollector {
    private static final String VALIDATION_QUERY = "SELECT 1";
    private static final String TYPE = "master";
    private DataSource ds;

    public MasterDbStatusCollector(DataSource ds) {
        this.ds = ds;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public DbStatus check() {
        try (Connection conn = this.ds.getConnection();){
            DbStatus dbStatus;
            block14: {
                PreparedStatement ps = conn.prepareStatement(VALIDATION_QUERY);
                try {
                    ps.execute();
                    dbStatus = DbStatus.OK;
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return dbStatus;
        }
        catch (SQLException e) {
            return DbStatus.ERROR;
        }
    }

    @Override
    public String type() {
        return TYPE;
    }
}

