/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.event;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import no.digipost.monitoring.event.AppBusinessEvent;
import no.digipost.monitoring.event.AppSensorEvent;
import no.digipost.monitoring.event.EventLogger;

public class AppBusinessEventLogger
implements EventLogger {
    static final String METRIC_APP_BUSINESS_EVENTS_TOTAL = "app_business_events_total";
    static final String METRIC_APP_BUSINESS_EVENTS_WARN_THRESHOLDS = "app_business_events_1min_warn_thresholds";
    static final String METRIC_APP_BUSINESS_EVENTS_ERROR_THRESHOLDS = "app_business_events_1min_error_thresholds";
    static final String METRIC_APP_BUSINESS_EVENTS_SENSOR_SCORE = "app_business_events_sensor_score";
    private final MeterRegistry meterRegistry;

    public AppBusinessEventLogger(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    Counter counter(AppBusinessEvent event) {
        return this.meterRegistry.counter(METRIC_APP_BUSINESS_EVENTS_TOTAL, (Iterable)Tags.of((String)"name", (String)event.getName()));
    }

    @Override
    public void log(AppBusinessEvent event) {
        this.log(event, 1.0);
    }

    @Override
    public void log(AppBusinessEvent event, double increment) {
        this.counter(event).increment(increment);
        event.getWarnThreshold().ifPresent(e -> this.meterRegistry.gauge(METRIC_APP_BUSINESS_EVENTS_WARN_THRESHOLDS, (Iterable)Tags.of((String)"name", (String)event.getName()), e.getOneMinuteThreshold()));
        event.getErrorThreshold().ifPresent(e -> this.meterRegistry.gauge(METRIC_APP_BUSINESS_EVENTS_ERROR_THRESHOLDS, (Iterable)Tags.of((String)"name", (String)event.getName()), e.getOneMinuteThreshold()));
        if (event instanceof AppSensorEvent) {
            this.meterRegistry.gauge(METRIC_APP_BUSINESS_EVENTS_SENSOR_SCORE, (Iterable)Tags.of((String)"name", (String)event.getName()), ((AppSensorEvent)event).getSensorScore());
        }
    }
}

