/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.micrometer;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.jar.Manifest;
import no.digipost.monitoring.micrometer.JarManifest;

public class ApplicationInfoMetrics
implements MeterBinder {
    final Manifest manifest;

    public ApplicationInfoMetrics() throws ClassNotFoundException {
        this.manifest = new JarManifest();
    }

    public ApplicationInfoMetrics(Class classFromJar) {
        this.manifest = new JarManifest(classFromJar);
    }

    public void bindTo(MeterRegistry registry) {
        if (this.manifest.getMainAttributes().isEmpty()) {
            return;
        }
        String artifactId = this.manifest.getMainAttributes().getValue("Implementation-Title");
        registry.config().commonTags(new String[]{"application", artifactId});
        Tags tags = Tags.of((String[])new String[]{"buildTime", this.manifest.getMainAttributes().getValue("Git-Build-Time"), "buildVersion", this.manifest.getMainAttributes().getValue("Git-Build-Version"), "buildNumber", this.manifest.getMainAttributes().getValue("Git-Commit"), "javaBuildVersion", this.manifest.getMainAttributes().getValue("Build-Jdk-Spec"), "javaVersion", (String)System.getProperties().get("java.version")});
        Gauge.builder((String)"app.info", () -> 1.0).description("General build and runtime information about the application. This is a static value").tags((Iterable)tags).register(registry);
    }
}

