/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.prometheus;

import com.sun.net.httpserver.HttpServer;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.function.BiConsumer;

public class SimplePrometheusServer {
    private static final String METRICS_PATH = "/metrics";
    private BiConsumer<String, Object> infoLogger;

    public SimplePrometheusServer(BiConsumer<String, Object> infoLogger) {
        this.infoLogger = infoLogger;
    }

    public void startMetricsServer(PrometheusMeterRegistry prometheusContext, int prometheusPort) {
        try {
            HttpServer server = HttpServer.create(new InetSocketAddress(prometheusPort), 0);
            server.createContext(METRICS_PATH, httpExchange -> {
                String response = prometheusContext.scrape();
                httpExchange.sendResponseHeaders(200, response.getBytes().length);
                try (OutputStream os = httpExchange.getResponseBody();){
                    os.write(response.getBytes());
                }
            });
            new Thread(server::start, "SimplePrometheusServer").start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> server.stop(2), "SimplePrometheusServerShutdownHook"));
            this.infoLogger.accept("Started Prometheus metrics endpoint server on port {}", prometheusPort);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

