/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.servlet;

import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ActiveRequestsFilter
implements Filter {
    final Map<UUID, RequestMetaInfo> activeRequests = new ConcurrentHashMap<UUID, RequestMetaInfo>();
    private final Config config;

    public ActiveRequestsFilter(MeterRegistry registry, Config config) {
        this.config = config;
        registry.gauge("app_http_requests_active", this.activeRequests, Map::size);
        registry.gauge("app_http_requests_max", (Number)config.getMaxThreads());
        registry.gauge("app_http_requests_longrunning", Collections.emptyList(), this.activeRequests, activeRequests -> this.getLongRunning((Map<UUID, RequestMetaInfo>)activeRequests, config.longRunningThreshold).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        UUID requestId = UUID.randomUUID();
        RequestMetaInfo metaInfo = ActiveRequestsFilter.createRequestMetaInfo(servletRequest, Instant.now());
        try {
            this.activeRequests.put(requestId, metaInfo);
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.activeRequests.remove(requestId);
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    private boolean excludedRequest(RequestMetaInfo requestMetaInfo) {
        return this.config.longRunningExclusions.stream().anyMatch(p -> p.test(requestMetaInfo));
    }

    private List<RequestMetaInfo> getLongRunning(Map<UUID, RequestMetaInfo> activeRequests, Duration longRunningThreshold) {
        Instant deadline = Instant.now().minus(longRunningThreshold);
        return activeRequests.values().stream().filter(m -> m.isOlderThan(deadline) && !this.excludedRequest((RequestMetaInfo)m)).collect(Collectors.toList());
    }

    private static RequestMetaInfo createRequestMetaInfo(ServletRequest servletRequest, Instant now) {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpReq = (HttpServletRequest)servletRequest;
            String path = httpReq.getRequestURI();
            String method = httpReq.getMethod();
            return new RequestMetaInfo(path, method, now);
        }
        return new RequestMetaInfo();
    }

    public static class Config {
        private Duration longRunningThreshold = Duration.ofMinutes(1L);
        private int maxThreads;
        private List<Predicate<RequestMetaInfo>> longRunningExclusions = Collections.emptyList();

        private Config(int maxThreads) {
            this.maxThreads = maxThreads;
        }

        public static Config forMaxThreads(int maxThreads) {
            return new Config(maxThreads);
        }

        public Config longRunningThreshold(Duration longRunningThreshold) {
            this.longRunningThreshold = longRunningThreshold;
            return this;
        }

        public Config longRunningExclusions(List<Predicate<RequestMetaInfo>> longRunningExclusions) {
            this.longRunningExclusions = longRunningExclusions;
            return this;
        }

        public int getMaxThreads() {
            return this.maxThreads;
        }
    }

    public static class RequestMetaInfo {
        public final String path;
        public final String method;
        public final Instant requestTime;

        public RequestMetaInfo(String path, String method, Instant requestTime) {
            this.path = path;
            this.method = method;
            this.requestTime = requestTime;
        }

        public RequestMetaInfo() {
            this("?", "?", Instant.now());
        }

        public boolean isOlderThan(Instant deadline) {
            return this.requestTime.isBefore(deadline);
        }

        public String toString() {
            return this.requestTime.toString() + " " + this.method + " " + this.path;
        }
    }
}

