/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.async;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

class DaemonThreadNamingFactory
implements ThreadFactory {
    private final ThreadFactory backingFactory = Executors.defaultThreadFactory();
    private final AtomicLong threadNum = new AtomicLong(0L);
    private final Function<Long, String> namingScheme;

    public DaemonThreadNamingFactory(String threadBaseName) {
        if (threadBaseName == null || threadBaseName.isEmpty()) {
            throw new IllegalArgumentException("missing thread base name (null or empty)");
        }
        this.namingScheme = threadNum -> threadBaseName + "-" + threadNum;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread newThread = this.backingFactory.newThread(r);
        newThread.setName(this.namingScheme.apply(this.threadNum.incrementAndGet()));
        newThread.setDaemon(true);
        return newThread;
    }

    public static DaemonThreadNamingFactory withPrefix(String threadBaseName) {
        return new DaemonThreadNamingFactory(threadBaseName);
    }
}

