/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.certificate;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import no.digipost.monitoring.certificate.MonitoredX509Certificate;

public final class CertificateExpiryMetrics
implements MeterBinder {
    public static final int DEFAULT_DAYS_TO_EXPIRY_WARN_THRESHOLD = 60;
    private final List<MonitoredX509Certificate> monitoredX509Certificates;
    private final Clock clock;
    private final int daysToExpiryWarnThreshold;

    public CertificateExpiryMetrics(List<MonitoredX509Certificate> monitoredX509Certificates, Clock clock) {
        this(monitoredX509Certificates, clock, 60);
    }

    public CertificateExpiryMetrics(List<MonitoredX509Certificate> monitoredX509Certificates, Clock clock, int daysToExpiryWarnThreshold) {
        this.clock = clock;
        this.daysToExpiryWarnThreshold = daysToExpiryWarnThreshold;
        this.monitoredX509Certificates = Objects.requireNonNull(monitoredX509Certificates, "monitoredX509Certificates can not be null");
    }

    public void bindTo(MeterRegistry registry) {
        try {
            for (MonitoredX509Certificate cert : this.monitoredX509Certificates) {
                this.registerGauge(registry, cert);
            }
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    private void registerGauge(MeterRegistry registry, MonitoredX509Certificate monitoredX509Certificate) throws KeyStoreException {
        X509Certificate cert = monitoredX509Certificate.certificate;
        List<Tag> tags = Arrays.asList(Tag.of((String)"alias", (String)monitoredX509Certificate.description.orElse(cert.getSerialNumber().toString())), Tag.of((String)"issuer", (String)cert.getIssuerX500Principal().getName()), Tag.of((String)"subject", (String)cert.getSubjectX500Principal().getName()), Tag.of((String)"notAfter", (String)cert.getNotAfter().toString()), Tag.of((String)"notBefore", (String)cert.getNotBefore().toString()));
        registry.gauge("cert_expiry", tags, (Object)cert, c -> Duration.between(Instant.now(this.clock), c.getNotAfter().toInstant()).getSeconds());
        registry.gauge("certificates_status", tags, (Object)cert, c -> {
            long daysToExpiry = ChronoUnit.DAYS.between(LocalDate.now(this.clock), LocalDateTime.ofInstant(c.getNotAfter().toInstant(), this.clock.getZone()).toLocalDate());
            if (daysToExpiry > (long)this.daysToExpiryWarnThreshold) {
                return ValidityStatus.VALID.code();
            }
            if (daysToExpiry <= 0L) {
                return ValidityStatus.INVALID.code();
            }
            return ValidityStatus.EXPIRING.code();
        });
    }

    static enum ValidityStatus {
        INVALID(-1),
        EXPIRING(0),
        VALID(1);

        private int i;

        private ValidityStatus(int i) {
            this.i = i;
        }

        public int code() {
            return this.i;
        }
    }
}

