/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import no.digipost.monitoring.logging.LoggerThresholdMetric;
import no.digipost.monitoring.util.Minutes;
import org.slf4j.LoggerFactory;

public class LogbackLoggerMetrics
implements MeterBinder {
    private final LoggerContext loggerContext;
    private final String loggerName;
    private Counter traceCounter;
    private Counter debugCounter;
    private Counter infoCounter;
    private Counter warnCounter;
    private Counter errorCounter;
    private final List<LoggerThresholdMetric> threshold5MinMetrics = new ArrayList<LoggerThresholdMetric>();
    private final Set<String> excludedLoggerNameSet = new HashSet<String>();

    private LogbackLoggerMetrics(String loggerName) {
        this.loggerName = loggerName;
        this.loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
    }

    public static LogbackLoggerMetrics forRootLogger() {
        return new LogbackLoggerMetrics("ROOT");
    }

    public static LogbackLoggerMetrics forLogger(String loggerName) {
        return new LogbackLoggerMetrics(loggerName);
    }

    public LogbackLoggerMetrics warnThreshold5min(double threshold) {
        this.threshold5MinMetrics.add(new LoggerThresholdMetric(this.loggerName, threshold, "warn", Minutes.of(5L)));
        return this;
    }

    public LogbackLoggerMetrics errorThreshold5min(double threshold) {
        this.threshold5MinMetrics.add(new LoggerThresholdMetric(this.loggerName, threshold, "error", Minutes.of(5L)));
        return this;
    }

    public LogbackLoggerMetrics excludeLogger(String loggerName) {
        this.excludedLoggerNameSet.add(loggerName);
        return this;
    }

    public void bindTo(MeterRegistry registry) {
        this.traceCounter = this.createCounter(registry, "trace");
        this.debugCounter = this.createCounter(registry, "debug");
        this.infoCounter = this.createCounter(registry, "info");
        this.warnCounter = this.createCounter(registry, "warn");
        this.errorCounter = this.createCounter(registry, "error");
        Logger logger = this.loggerContext.getLogger(this.loggerName);
        MetricsAppender metricsAppender = new MetricsAppender();
        metricsAppender.setContext((Context)this.loggerContext);
        metricsAppender.start();
        logger.addAppender((Appender)metricsAppender);
        for (LoggerThresholdMetric loggerThresholdMetric : this.threshold5MinMetrics) {
            loggerThresholdMetric.bindTo(registry);
        }
    }

    private Counter createCounter(MeterRegistry registry, String level) {
        return Counter.builder((String)"logback_logger_events").tag("logger", this.loggerName).tag("level", level).register(registry);
    }

    private class MetricsAppender
    extends UnsynchronizedAppenderBase<ILoggingEvent> {
        private MetricsAppender() {
        }

        public void start() {
            super.start();
        }

        protected void append(ILoggingEvent event) {
            if (LogbackLoggerMetrics.this.excludedLoggerNameSet.contains(event.getLoggerName())) {
                return;
            }
            try {
                switch (event.getLevel().toInt()) {
                    case 5000: {
                        LogbackLoggerMetrics.this.traceCounter.increment();
                        break;
                    }
                    case 10000: {
                        LogbackLoggerMetrics.this.debugCounter.increment();
                        break;
                    }
                    case 20000: {
                        LogbackLoggerMetrics.this.infoCounter.increment();
                        break;
                    }
                    case 30000: {
                        LogbackLoggerMetrics.this.warnCounter.increment();
                        break;
                    }
                    case 40000: {
                        LogbackLoggerMetrics.this.errorCounter.increment();
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

