/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.micrometer;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.jar.Manifest;
import no.digipost.monitoring.micrometer.JarManifest;

public class ApplicationInfoMetrics
implements MeterBinder {
    final Manifest manifest;

    public ApplicationInfoMetrics() throws ClassNotFoundException {
        this.manifest = new JarManifest();
    }

    public ApplicationInfoMetrics(Class<?> classFromJar) {
        this.manifest = new JarManifest(classFromJar);
    }

    public void bindTo(MeterRegistry registry) {
        this.fromManifestOrEnv("Implementation-Title").ifPresent(artifactId -> registry.config().commonTags(new String[]{"application", artifactId}));
        ArrayList<Tag> tags = new ArrayList<Tag>();
        this.addTagIfValuePresent(tags, "buildTime", "Git-Build-Time");
        this.addTagIfValuePresent(tags, "buildVersion", "Git-Build-Version");
        this.addTagIfValuePresent(tags, "buildNumber", "Git-Commit");
        this.addTagIfValuePresent(tags, "javaBuildVersion", "Build-Jdk-Spec");
        tags.add(Tag.of((String)"javaVersion", (String)((String)System.getProperties().get("java.version"))));
        Gauge.builder((String)"app.info", () -> 1.0).description("General build and runtime information about the application. This is a static value").tags(tags).register(registry);
    }

    private void addTagIfValuePresent(List<Tag> tags, String tagKey, String valueName) {
        this.fromManifestOrEnv(valueName).ifPresent(value -> tags.add(Tag.of((String)tagKey, (String)value)));
    }

    private Optional<String> fromManifestOrEnv(String name) {
        String value = ApplicationInfoMetrics.environmentVariableOrSystemProperty(name);
        if (value == null) {
            value = this.manifest.getMainAttributes().getValue(name);
        }
        return Optional.ofNullable(value);
    }

    private static String environmentVariableOrSystemProperty(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            value = System.getenv(name);
        }
        return value;
    }
}

