/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.thirdparty;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import no.digipost.monitoring.micrometer.AppStatus;
import no.digipost.monitoring.thirdparty.TimedThirdPartyCallDescriptor;

public class TimedThirdPartyCall<RESULT> {
    private final TimedThirdPartyCallDescriptor descriptor;
    private final BiFunction<? super RESULT, Optional<RuntimeException>, AppStatus> reportWarnPredicate;

    public TimedThirdPartyCall(TimedThirdPartyCallDescriptor descriptor, BiFunction<? super RESULT, Optional<RuntimeException>, AppStatus> reportWarnPredicate) {
        this.descriptor = descriptor;
        this.reportWarnPredicate = reportWarnPredicate;
    }

    public RESULT call(Supplier<RESULT> thirdPartyCall) {
        Object returnValue = null;
        Optional<Object> thrown = Optional.empty();
        try {
            returnValue = this.descriptor.timer.record(thirdPartyCall);
        }
        catch (RuntimeException t) {
            thrown = Optional.of(t);
        }
        AppStatus appStatus = this.reportWarnPredicate.apply(returnValue, thrown);
        if (AppStatus.FAILED == appStatus) {
            this.descriptor.failedCounter.increment();
        } else if (AppStatus.WARN == appStatus) {
            this.descriptor.warnCounter.increment();
        } else {
            this.descriptor.successCounter.increment();
        }
        thrown.ifPresent(e -> {
            throw e;
        });
        return (RESULT)returnValue;
    }
}

