/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.monitoring.thirdparty;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.Optional;
import java.util.function.BiFunction;
import no.digipost.monitoring.micrometer.AppStatus;
import no.digipost.monitoring.thirdparty.NoResultTimedThirdPartyCall;
import no.digipost.monitoring.thirdparty.TimedThirdPartyCall;

public class TimedThirdPartyCallDescriptor {
    private static final BiFunction<Object, Optional<RuntimeException>, AppStatus> failOnException = (response, possibleException) -> possibleException.isPresent() ? AppStatus.FAILED : AppStatus.OK;
    private static final BiFunction<Object, Optional<RuntimeException>, AppStatus> failOnExceptionOrNull = (response, possibleException) -> possibleException.isPresent() || response == null ? AppStatus.FAILED : AppStatus.OK;
    private static final BiFunction<Boolean, Optional<RuntimeException>, AppStatus> failOnExceptionOrFalse = (response, possibleException) -> possibleException.isPresent() || response != null && response == false ? AppStatus.FAILED : AppStatus.OK;
    final Counter successCounter;
    final Counter warnCounter;
    final Counter failedCounter;
    final Timer timer;
    private final String group;
    private final String endpoint;

    private TimedThirdPartyCallDescriptor(String group, String endpoint, MeterRegistry prometheusRegistry, double ... percentiles) {
        this.group = group;
        this.endpoint = endpoint;
        this.successCounter = prometheusRegistry.counter("app_third_party_call_total", (Iterable)Tags.of((String[])new String[]{"name", this.getName(), "status", AppStatus.OK.name()}));
        this.warnCounter = prometheusRegistry.counter("app_third_party_call_total", (Iterable)Tags.of((String[])new String[]{"name", this.getName(), "status", AppStatus.WARN.name()}));
        this.failedCounter = prometheusRegistry.counter("app_third_party_call_total", (Iterable)Tags.of((String[])new String[]{"name", this.getName(), "status", AppStatus.FAILED.name()}));
        this.timer = percentiles.length == 0 ? Timer.builder((String)"app_third_party_call").tags((Iterable)Tags.of((String)"name", (String)this.getName())).publishPercentiles(new double[]{0.5, 0.95, 0.99}).register(prometheusRegistry) : Timer.builder((String)"app_third_party_call").tags((Iterable)Tags.of((String)"name", (String)this.getName())).publishPercentiles(percentiles).register(prometheusRegistry);
    }

    public static TimedThirdPartyCallDescriptor create(String group, String endpoint, MeterRegistry prometheusRegistry, double ... percentiles) {
        return new TimedThirdPartyCallDescriptor(group, endpoint, prometheusRegistry, percentiles);
    }

    public NoResultTimedThirdPartyCallDescriptor noResult() {
        return new NoResultTimedThirdPartyCallDescriptor();
    }

    public <RESULT> TimedThirdPartyCall<RESULT> exceptionAsFailure() {
        return this.build(failOnException);
    }

    public <RESULT> TimedThirdPartyCall<RESULT> exceptionAndNullAsFailure() {
        return this.build(failOnExceptionOrNull);
    }

    public TimedThirdPartyCall<Boolean> exceptionAndFalseAsFailure() {
        return new TimedThirdPartyCall<Boolean>(this, failOnExceptionOrFalse);
    }

    public <RESULT> TimedThirdPartyCall<RESULT> callResponseStatus(BiFunction<? super RESULT, Optional<RuntimeException>, AppStatus> reportWarnPredicate) {
        return this.build(reportWarnPredicate);
    }

    private <RESULT> TimedThirdPartyCall<RESULT> build(BiFunction<? super RESULT, Optional<RuntimeException>, AppStatus> reportWarnPredicate) {
        return new TimedThirdPartyCall<RESULT>(this, reportWarnPredicate);
    }

    String getName() {
        return this.group + "_" + this.endpoint;
    }

    public class NoResultTimedThirdPartyCallDescriptor {
        private NoResultTimedThirdPartyCallDescriptor() {
        }

        public NoResultTimedThirdPartyCall exceptionAsFailure() {
            return new NoResultTimedThirdPartyCall(TimedThirdPartyCallDescriptor.this.build(failOnException));
        }
    }
}

