/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.function.Function;
import no.digipost.signature.client.asice.DocumentBundleProcessor;
import no.digipost.signature.client.core.SignatureJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpDocumentBundleToDisk
implements DocumentBundleProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DumpDocumentBundleToDisk.class);
    static final String TIMESTAMP_PATTERN = "yyyyMMddHHmmssSSS";
    private final Path directory;
    private final Clock clock;
    static final Function<String, String> referenceFilenamePart = reference -> reference.replace(' ', '_') + "-";

    public DumpDocumentBundleToDisk(Path directory, Clock clock) {
        this.directory = directory;
        this.clock = clock;
    }

    @Override
    public void process(SignatureJob job, InputStream documentBundle) throws IOException {
        if (!Files.isDirectory(this.directory, new LinkOption[0])) {
            throw new InvalidDirectoryException(this.directory);
        }
        DateTimeFormatter timestampFormat = DateTimeFormatter.ofPattern(TIMESTAMP_PATTERN);
        Optional<String> reference = Optional.ofNullable(job.getReference());
        String filename = timestampFormat.format(ZonedDateTime.now(this.clock)) + "-" + reference.map(referenceFilenamePart).orElse("") + "asice.zip";
        Path target = this.directory.resolve(filename);
        LOG.info("Dumping document bundle{}to {}", (Object)reference.map(ref -> String.format(" for job with reference '%s' ", ref)).orElse(" "), (Object)target);
        Files.copy(documentBundle, target, new CopyOption[0]);
    }

    public static class InvalidDirectoryException
    extends IOException {
        InvalidDirectoryException(Path path) {
            super("The path " + path + (!Files.exists(path, new LinkOption[0]) ? " does not exist" : " is not a valid directory"));
        }
    }
}

