/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice.manifest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import no.digipost.signature.client.asice.manifest.Manifest;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.SignatureJob;
import no.digipost.signature.client.core.exceptions.RuntimeIOException;
import no.digipost.signature.client.core.exceptions.XmlValidationException;
import no.digipost.signature.client.core.internal.xml.Marshalling;
import org.springframework.oxm.MarshallingFailureException;
import org.xml.sax.SAXParseException;

public abstract class ManifestCreator<JOB extends SignatureJob> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Manifest createManifest(JOB job, Sender sender) {
        Object xmlManifest = this.buildXmlManifest(job, sender);
        try (ByteArrayOutputStream manifestStream = new ByteArrayOutputStream();){
            Marshalling.marshal(xmlManifest, manifestStream);
            Manifest manifest = new Manifest(manifestStream.toByteArray());
            return manifest;
        }
        catch (MarshallingFailureException e) {
            if (!(e.getMostSpecificCause() instanceof SAXParseException)) throw e;
            throw new XmlValidationException("Unable to validate generated Manifest XML. This typically happens if one or more values are not in accordance with the XSD. You may inspect the cause (by calling getCause()) to see which constraint has been violated.", (SAXParseException)e.getMostSpecificCause());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    abstract Object buildXmlManifest(JOB var1, Sender var2);
}

