/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice.signature;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import no.digipost.signature.client.asice.ASiCEAttachable;
import no.digipost.signature.client.asice.signature.CreateXAdESProperties;
import no.digipost.signature.client.asice.signature.Signature;
import no.digipost.signature.client.core.exceptions.ConfigurationException;
import no.digipost.signature.client.core.exceptions.RuntimeIOException;
import no.digipost.signature.client.core.exceptions.XmlConfigurationException;
import no.digipost.signature.client.core.exceptions.XmlValidationException;
import no.digipost.signature.client.security.KeyStoreConfig;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.xml.validation.SchemaLoaderUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CreateSignature {
    public static final String C14V1 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private final String asicNamespace = "http://uri.etsi.org/2918/v1.2.1#";
    private final String signedPropertiesType = "http://uri.etsi.org/01903#SignedProperties";
    private final DigestMethod sha256DigestMethod;
    private final CanonicalizationMethod canonicalizationMethod;
    private final Transform canonicalXmlTransform;
    private final CreateXAdESProperties createXAdESProperties;
    private final TransformerFactory transformerFactory;
    private final Schema schema;

    public CreateSignature(Clock clock) {
        this.createXAdESProperties = new CreateXAdESProperties(clock);
        this.transformerFactory = TransformerFactory.newInstance();
        try {
            XMLSignatureFactory xmlSignatureFactory = this.getSignatureFactory();
            this.sha256DigestMethod = xmlSignatureFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
            this.canonicalizationMethod = xmlSignatureFactory.newCanonicalizationMethod(C14V1, (C14NMethodParameterSpec)null);
            this.canonicalXmlTransform = xmlSignatureFactory.newTransform(C14V1, (TransformParameterSpec)null);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new ConfigurationException("Failed to initialize XML-signing", e);
        }
        this.schema = this.loadSchema();
    }

    private Schema loadSchema() {
        try {
            return SchemaLoaderUtils.loadSchema((Resource[])new Resource[]{new ClassPathResource("/thirdparty/xmldsig-core-schema.xsd"), new ClassPathResource("/thirdparty/ts_102918v010201.xsd")}, (String)"http://www.w3.org/2001/XMLSchema");
        }
        catch (IOException | SAXException e) {
            throw new ConfigurationException("Failed to load schemas for validating signatures", e);
        }
    }

    public Signature createSignature(List<ASiCEAttachable> attachedFiles, KeyStoreConfig keyStoreConfig) {
        ByteArrayOutputStream outputStream;
        XMLSignatureFactory xmlSignatureFactory = this.getSignatureFactory();
        SignatureMethod signatureMethod = this.getSignatureMethod(xmlSignatureFactory);
        List<Reference> references = this.references(xmlSignatureFactory, attachedFiles);
        references.add(xmlSignatureFactory.newReference("#SignedProperties", this.sha256DigestMethod, Collections.singletonList(this.canonicalXmlTransform), "http://uri.etsi.org/01903#SignedProperties", null));
        Document document = this.createXAdESProperties.createPropertiesToSign(attachedFiles, keyStoreConfig.getCertificate());
        KeyInfo keyInfo = this.keyInfo(xmlSignatureFactory, keyStoreConfig.getCertificateChain());
        SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(this.canonicalizationMethod, signatureMethod, references);
        XMLObject xmlObject = xmlSignatureFactory.newXMLObject(Collections.singletonList(new DOMStructure(document.getDocumentElement())), null, null, null);
        XMLSignature xmlSignature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo, Collections.singletonList(xmlObject), "Signature", null);
        try {
            xmlSignature.sign(new DOMSignContext(keyStoreConfig.getPrivateKey(), (Node)document));
        }
        catch (MarshalException e) {
            throw new XmlConfigurationException("failed to read ASiC-E XML for signing", e);
        }
        catch (XMLSignatureException e) {
            throw new XmlConfigurationException("Failed to sign ASiC-E element.", e);
        }
        this.wrapSignatureInXADeSEnvelope(document);
        try {
            outputStream = new ByteArrayOutputStream();
            Transformer transformer = this.transformerFactory.newTransformer();
            this.schema.newValidator().validate(new DOMSource(document));
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (TransformerException e) {
            throw new ConfigurationException("Unable to serialize XML.", e);
        }
        catch (SAXException e) {
            throw new XmlValidationException("Failed to validate generated signature.xml. Verify that the input is valid and that there are no illegal symbols in file names etc.", e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return new Signature(outputStream.toByteArray());
    }

    private SignatureMethod getSignatureMethod(XMLSignatureFactory xmlSignatureFactory) {
        try {
            return xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new ConfigurationException("Failed to initialize XML-signing", e);
        }
    }

    private List<Reference> references(XMLSignatureFactory xmlSignatureFactory, List<ASiCEAttachable> files) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        for (int i = 0; i < files.size(); ++i) {
            try {
                String signatureElementId = String.format("ID_%s", i);
                String uri = URLEncoder.encode(files.get(i).getFileName(), "UTF-8");
                Reference reference = xmlSignatureFactory.newReference(uri, this.sha256DigestMethod, null, null, signatureElementId, DigestUtils.sha256((byte[])files.get(i).getBytes()));
                result.add(reference);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private KeyInfo keyInfo(XMLSignatureFactory xmlSignatureFactory, Certificate[] sertifikater) {
        KeyInfoFactory keyInfoFactory = xmlSignatureFactory.getKeyInfoFactory();
        X509Data x509Data = keyInfoFactory.newX509Data(Arrays.asList(sertifikater));
        return keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
    }

    private void wrapSignatureInXADeSEnvelope(Document document) {
        Node signatureElement = document.removeChild(document.getDocumentElement());
        Element xadesElement = document.createElementNS("http://uri.etsi.org/2918/v1.2.1#", "XAdESSignatures");
        xadesElement.appendChild(signatureElement);
        document.appendChild(xadesElement);
    }

    private XMLSignatureFactory getSignatureFactory() {
        try {
            return XMLSignatureFactory.getInstance("DOM", "XMLDSig");
        }
        catch (NoSuchProviderException e) {
            throw new ConfigurationException("Failed to find XML Digital Signature provided. The library depends on default Java-provider");
        }
    }
}

