/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice.signature;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import no.digipost.signature.api.xml.thirdparty.xades.CertIDType;
import no.digipost.signature.api.xml.thirdparty.xades.DataObjectFormat;
import no.digipost.signature.api.xml.thirdparty.xades.DigestAlgAndValueType;
import no.digipost.signature.api.xml.thirdparty.xades.QualifyingProperties;
import no.digipost.signature.api.xml.thirdparty.xades.SignedDataObjectProperties;
import no.digipost.signature.api.xml.thirdparty.xades.SignedProperties;
import no.digipost.signature.api.xml.thirdparty.xades.SignedSignatureProperties;
import no.digipost.signature.api.xml.thirdparty.xades.SigningCertificate;
import no.digipost.signature.api.xml.thirdparty.xmldsig.DigestMethod;
import no.digipost.signature.api.xml.thirdparty.xmldsig.X509IssuerSerialType;
import no.digipost.signature.client.asice.ASiCEAttachable;
import no.digipost.signature.client.core.exceptions.CertificateException;
import no.digipost.signature.client.core.exceptions.XmlConfigurationException;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class CreateXAdESProperties {
    private final DigestMethod sha1DigestMethod = new DigestMethod(Collections.emptyList(), "http://www.w3.org/2000/09/xmldsig#sha1");
    private final Clock clock;
    private static Jaxb2Marshaller marshaller = new Jaxb2Marshaller();

    CreateXAdESProperties(Clock clock) {
        this.clock = clock;
    }

    Document createPropertiesToSign(List<ASiCEAttachable> files, X509Certificate certificate) {
        byte[] certificateDigestValue;
        try {
            certificateDigestValue = DigestUtils.sha1((byte[])certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new CertificateException("Unable to get encoded from of certificate", e);
        }
        DigestAlgAndValueType certificateDigest = new DigestAlgAndValueType(this.sha1DigestMethod, certificateDigestValue);
        X509IssuerSerialType certificateIssuer = new X509IssuerSerialType(certificate.getIssuerDN().getName(), certificate.getSerialNumber());
        SigningCertificate signingCertificate = new SigningCertificate(Collections.singletonList(new CertIDType(certificateDigest, certificateIssuer, null)));
        ZonedDateTime now = ZonedDateTime.now(this.clock);
        SignedSignatureProperties signedSignatureProperties = new SignedSignatureProperties(now, signingCertificate, null, null, null, null);
        SignedDataObjectProperties signedDataObjectProperties = new SignedDataObjectProperties(this.dataObjectFormats(files), null, null, null, null);
        SignedProperties signedProperties = new SignedProperties(signedSignatureProperties, signedDataObjectProperties, "SignedProperties");
        QualifyingProperties qualifyingProperties = new QualifyingProperties(signedProperties, null, "#Signature", null);
        DOMResult domResult = new DOMResult();
        marshaller.marshal((Object)qualifyingProperties, (Result)domResult);
        Document document = (Document)domResult.getNode();
        this.markAsIdProperty(document, "SignedProperties", "Id");
        return document;
    }

    private List<DataObjectFormat> dataObjectFormats(List<ASiCEAttachable> files) {
        ArrayList<DataObjectFormat> result = new ArrayList<DataObjectFormat>();
        for (int i = 0; i < files.size(); ++i) {
            String signatureElementIdReference = String.format("#ID_%s", i);
            result.add(new DataObjectFormat(null, null, files.get(i).getMimeType(), null, signatureElementIdReference));
        }
        return result;
    }

    private void markAsIdProperty(Document document, String elementName, String property) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            Element idElement = (Element)xPath.evaluate("//*[local-name()='" + elementName + "']", document, XPathConstants.NODE);
            idElement.setIdAttribute(property, true);
        }
        catch (XPathExpressionException e) {
            throw new XmlConfigurationException("XPath on generated XML failed.", e);
        }
    }

    static {
        marshaller.setClassesToBeBound(new Class[]{QualifyingProperties.class});
    }
}

