/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core;

import no.digipost.signature.client.asice.ASiCEAttachable;

public abstract class Document
implements ASiCEAttachable {
    private String title;
    private String message;
    private String fileName;
    private byte[] document;
    private FileType fileType;

    protected Document(String title, String message, String fileName, FileType fileType, byte[] document) {
        this.title = title;
        this.message = message;
        this.fileName = fileName;
        this.fileType = fileType;
        this.document = document;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public byte[] getBytes() {
        return this.document;
    }

    @Override
    public String getMimeType() {
        return this.fileType.mimeType;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public static enum FileType {
        PDF("application/pdf"),
        TXT("text/plain");

        public final String mimeType;

        private FileType(String mimeType) {
            this.mimeType = mimeType;
        }
    }
}

