/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.exceptions;

import javax.ws.rs.core.Response;
import no.digipost.signature.api.xml.XMLError;
import no.digipost.signature.client.core.exceptions.SignatureException;

public class UnexpectedResponseException
extends SignatureException {
    private final XMLError error;
    private final Response.StatusType actualStatus;

    public UnexpectedResponseException(Object errorEntity, Response.StatusType actual, Response.StatusType ... expected) {
        this(errorEntity, (Throwable)null, actual, expected);
    }

    public UnexpectedResponseException(Object errorEntity, Throwable cause, Response.StatusType actual, Response.StatusType ... expected) {
        super("Expected " + UnexpectedResponseException.prettyprintExpectedStatuses(expected) + ", but got " + actual.getStatusCode() + " " + actual.getReasonPhrase() + (errorEntity != null ? " [" + errorEntity + "]" : "") + (cause != null ? " - " + cause.getClass().getSimpleName() + ": '" + cause.getMessage() + "'." : ""), cause);
        this.error = errorEntity instanceof XMLError ? (XMLError)errorEntity : null;
        this.actualStatus = actual;
    }

    public Response.StatusType getActualStatus() {
        return this.actualStatus;
    }

    public String getErrorCode() {
        return this.error != null ? this.error.getErrorCode() : null;
    }

    public String getErrorMessage() {
        return this.error != null ? this.error.getErrorMessage() : null;
    }

    public String getErrorType() {
        return this.error != null ? this.error.getErrorType() : null;
    }

    private static String prettyprintExpectedStatuses(Response.StatusType ... statuses) {
        String message = "[" + UnexpectedResponseException.prettyprintSingleStatus(statuses[0]);
        for (int i = 1; i < statuses.length; ++i) {
            message = message + ", " + UnexpectedResponseException.prettyprintSingleStatus(statuses[i]);
        }
        return message + "]";
    }

    private static String prettyprintSingleStatus(Response.StatusType status) {
        return status.getStatusCode() + " " + status.getReasonPhrase();
    }
}

