/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import no.digipost.signature.api.xml.XMLDirectSignatureJobRequest;
import no.digipost.signature.api.xml.XMLDirectSignatureJobResponse;
import no.digipost.signature.api.xml.XMLDirectSignatureJobStatusResponse;
import no.digipost.signature.api.xml.XMLError;
import no.digipost.signature.api.xml.XMLPortalSignatureJobRequest;
import no.digipost.signature.api.xml.XMLPortalSignatureJobResponse;
import no.digipost.signature.api.xml.XMLPortalSignatureJobStatusChangeResponse;
import no.digipost.signature.client.asice.DocumentBundle;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.exceptions.BrokerNotAuthorizedException;
import no.digipost.signature.client.core.exceptions.CantQueryStatusException;
import no.digipost.signature.client.core.exceptions.InvalidStatusQueryTokenException;
import no.digipost.signature.client.core.exceptions.JobCannotBeCancelledException;
import no.digipost.signature.client.core.exceptions.NotCancellableException;
import no.digipost.signature.client.core.exceptions.SenderNotSpecifiedException;
import no.digipost.signature.client.core.exceptions.SignatureException;
import no.digipost.signature.client.core.exceptions.TooEagerPollingException;
import no.digipost.signature.client.core.exceptions.UnexpectedResponseException;
import no.digipost.signature.client.core.internal.Cancellable;
import no.digipost.signature.client.core.internal.ClientExceptionMapper;
import no.digipost.signature.client.core.internal.Confirmable;
import no.digipost.signature.client.core.internal.ErrorCodes;
import no.digipost.signature.client.core.internal.Target;
import no.digipost.signature.client.core.internal.http.ResponseStatus;
import no.digipost.signature.client.core.internal.http.SignatureHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ClientHelper.class);
    public static final String NEXT_PERMITTED_POLL_TIME_HEADER = "X-Next-permitted-poll-time";
    private final SignatureHttpClient httpClient;
    private final Optional<Sender> globalSender;
    private final ClientExceptionMapper clientExceptionMapper;

    public ClientHelper(SignatureHttpClient httpClient, Optional<Sender> globalSender) {
        this.httpClient = httpClient;
        this.globalSender = globalSender;
        this.clientExceptionMapper = new ClientExceptionMapper();
    }

    public XMLDirectSignatureJobResponse sendSignatureJobRequest(XMLDirectSignatureJobRequest signatureJobRequest, DocumentBundle documentBundle, Optional<Sender> sender) {
        Sender actualSender = this.getActualSender(sender);
        BodyPart signatureJobBodyPart = new BodyPart((Object)signatureJobRequest, MediaType.APPLICATION_XML_TYPE);
        BodyPart documentBundleBodyPart = new BodyPart((Object)documentBundle.getInputStream(), MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return this.call(() -> new UsingBodyParts(signatureJobBodyPart, documentBundleBodyPart).postAsMultiPart(Target.DIRECT.path(actualSender), XMLDirectSignatureJobResponse.class));
    }

    public XMLPortalSignatureJobResponse sendPortalSignatureJobRequest(XMLPortalSignatureJobRequest signatureJobRequest, DocumentBundle documentBundle, Optional<Sender> sender) {
        Sender actualSender = this.getActualSender(sender);
        BodyPart signatureJobBodyPart = new BodyPart((Object)signatureJobRequest, MediaType.APPLICATION_XML_TYPE);
        BodyPart documentBundleBodyPart = new BodyPart((Object)documentBundle.getInputStream(), MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return this.call(() -> new UsingBodyParts(signatureJobBodyPart, documentBundleBodyPart).postAsMultiPart(Target.PORTAL.path(actualSender), XMLPortalSignatureJobResponse.class));
    }

    public XMLDirectSignatureJobStatusResponse sendSignatureJobStatusRequest(String statusUrl) {
        return this.call(() -> {
            Invocation.Builder request = this.httpClient.target(statusUrl).request().accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
            Throwable throwable = null;
            try (Response response = request.get();){
                Response.StatusType status = ResponseStatus.resolve(response.getStatus());
                if (status == Response.Status.OK) {
                    XMLDirectSignatureJobStatusResponse xMLDirectSignatureJobStatusResponse = (XMLDirectSignatureJobStatusResponse)response.readEntity(XMLDirectSignatureJobStatusResponse.class);
                    return xMLDirectSignatureJobStatusResponse;
                }
                try {
                    XMLError error;
                    if (status == Response.Status.FORBIDDEN) {
                        XMLError error2 = ClientHelper.extractError(response);
                        if (ErrorCodes.INVALID_STATUS_QUERY_TOKEN.sameAs(error2.getErrorCode())) {
                            throw new InvalidStatusQueryTokenException(statusUrl, error2.getErrorMessage());
                        }
                    } else if (status == Response.Status.NOT_FOUND && ErrorCodes.SIGNING_CEREMONY_NOT_COMPLETED.sameAs((error = ClientHelper.extractError(response)).getErrorCode())) {
                        throw new CantQueryStatusException(status, error.getErrorMessage());
                    }
                    throw this.exceptionForGeneralError(response);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        });
    }

    public InputStream getSignedDocumentStream(String uri) {
        return this.call(() -> this.parseResponse(this.httpClient.target(uri).request().accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_OCTET_STREAM_TYPE}).get(), InputStream.class));
    }

    public void cancel(Cancellable cancellable) {
        this.call(() -> {
            if (cancellable.getCancellationUrl() != null) {
                String url = cancellable.getCancellationUrl().getUrl();
                Throwable throwable = null;
                try (Response response = this.postEmptyEntity(url);){
                    Response.StatusType status = ResponseStatus.resolve(response.getStatus());
                    if (status == Response.Status.OK) {
                        return;
                    }
                    try {
                        if (status == Response.Status.CONFLICT) {
                            XMLError error = ClientHelper.extractError(response);
                            throw new JobCannotBeCancelledException(status, error.getErrorCode(), error.getErrorMessage());
                        }
                        throw this.exceptionForGeneralError(response);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
            throw new NotCancellableException();
        });
    }

    public XMLPortalSignatureJobStatusChangeResponse getPortalStatusChange(Optional<Sender> sender) {
        return this.getStatusChange(sender, Target.PORTAL, XMLPortalSignatureJobStatusChangeResponse.class);
    }

    public XMLDirectSignatureJobStatusResponse getDirectStatusChange(Optional<Sender> sender) {
        return this.getStatusChange(sender, Target.DIRECT, XMLDirectSignatureJobStatusResponse.class);
    }

    private <RESPONSE_CLASS> RESPONSE_CLASS getStatusChange(Optional<Sender> sender, Target target, Class<RESPONSE_CLASS> responseClass) {
        return (RESPONSE_CLASS)this.call(() -> {
            Invocation.Builder request = this.httpClient.signatureServiceRoot().path(target.path(this.getActualSender(sender))).request().accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
            Throwable throwable = null;
            try (Response response = request.get();){
                Response.StatusType status = ResponseStatus.resolve(response.getStatus());
                if (status == Response.Status.NO_CONTENT) {
                    Object var8_9 = null;
                    return var8_9;
                }
                if (status == Response.Status.OK) {
                    Object object = response.readEntity(responseClass);
                    return object;
                }
                try {
                    if (status == Response.Status.TOO_MANY_REQUESTS) {
                        throw new TooEagerPollingException(response.getHeaderString(NEXT_PERMITTED_POLL_TIME_HEADER));
                    }
                    throw this.exceptionForGeneralError(response);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        });
    }

    public void confirm(Confirmable confirmable) {
        this.call(() -> {
            block14: {
                if (confirmable.getConfirmationReference() != null) {
                    String url = confirmable.getConfirmationReference().getConfirmationUrl();
                    LOG.info("Sends confirmation for '{}' to URL {}", (Object)confirmable, (Object)url);
                    try (Response response = this.postEmptyEntity(url);){
                        Response.StatusType status = ResponseStatus.resolve(response.getStatus());
                        if (status != Response.Status.OK) {
                            throw this.exceptionForGeneralError(response);
                        }
                        break block14;
                    }
                }
                LOG.info("Does not need to send confirmation for '{}'", (Object)confirmable);
            }
        });
    }

    private <T> T call(Supplier<T> supplier) {
        return this.clientExceptionMapper.doWithMappedClientException(supplier);
    }

    private void call(Runnable action) {
        this.clientExceptionMapper.doWithMappedClientException(action);
    }

    private Sender getActualSender(Optional<Sender> sender) {
        return sender.orElse(this.globalSender.orElseThrow(SenderNotSpecifiedException.SENDER_NOT_SPECIFIED));
    }

    private Response postEmptyEntity(String uri) {
        return this.httpClient.target(uri).request().accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).header("Content-Length", (Object)0).post(Entity.entity(null, (MediaType)MediaType.APPLICATION_XML_TYPE));
    }

    private <T> T parseResponse(Response response, Class<T> responseType) {
        Response.StatusType status = ResponseStatus.resolve(response.getStatus());
        if (status == Response.Status.OK) {
            return (T)response.readEntity(responseType);
        }
        throw this.exceptionForGeneralError(response);
    }

    private SignatureException exceptionForGeneralError(Response response) {
        XMLError error = ClientHelper.extractError(response);
        if (ErrorCodes.BROKER_NOT_AUTHORIZED.sameAs(error.getErrorCode())) {
            return new BrokerNotAuthorizedException(error);
        }
        return new UnexpectedResponseException((Object)error, ResponseStatus.resolve(response.getStatus()), new Response.StatusType[]{Response.Status.OK});
    }

    private static XMLError extractError(Response response) {
        XMLError error;
        Optional<String> responseContentType = Optional.ofNullable(response.getHeaderString("Content-Type"));
        if (responseContentType.isPresent() && MediaType.valueOf((String)responseContentType.get()).equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            try {
                response.bufferEntity();
                error = (XMLError)response.readEntity(XMLError.class);
            }
            catch (Exception e) {
                throw new UnexpectedResponseException((Object)("Content-Type " + responseContentType.orElse("unknown") + ": " + Optional.ofNullable(response.readEntity(String.class)).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse("<no content in response>")), (Throwable)e, ResponseStatus.resolve(response.getStatus()), new Response.StatusType[]{Response.Status.OK});
            }
        } else {
            throw new UnexpectedResponseException((Object)("Content-Type " + responseContentType.orElse("unknown") + ": " + Optional.ofNullable(response.readEntity(String.class)).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse("<no content in response>")), ResponseStatus.resolve(response.getStatus()), new Response.StatusType[]{Response.Status.OK});
        }
        if (error == null) {
            throw new UnexpectedResponseException(null, ResponseStatus.resolve(response.getStatus()), new Response.StatusType[]{Response.Status.OK});
        }
        return error;
    }

    static /* synthetic */ SignatureHttpClient access$000(ClientHelper x0) {
        return x0.httpClient;
    }

    static /* synthetic */ Object access$100(ClientHelper x0, Response x1, Class x2) {
        return x0.parseResponse(x1, x2);
    }

    private class UsingBodyParts {
        private final List<BodyPart> parts;

        UsingBodyParts(BodyPart ... parts) {
            this.parts = Arrays.asList(parts);
        }

        /*
         * Exception decompiling
         */
        <T> T postAsMultiPart(String path, Class<T> responseType) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

