/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.io.InputStream;
import java.util.Optional;
import no.digipost.signature.api.xml.XMLDirectSignatureJobRequest;
import no.digipost.signature.api.xml.XMLDirectSignatureJobResponse;
import no.digipost.signature.api.xml.XMLDirectSignatureJobStatusResponse;
import no.digipost.signature.client.ClientConfiguration;
import no.digipost.signature.client.asice.CreateASiCE;
import no.digipost.signature.client.asice.DocumentBundle;
import no.digipost.signature.client.asice.manifest.CreateDirectManifest;
import no.digipost.signature.client.core.PAdESReference;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.XAdESReference;
import no.digipost.signature.client.core.internal.ClientHelper;
import no.digipost.signature.client.core.internal.http.SignatureHttpClientFactory;
import no.digipost.signature.client.direct.DirectJob;
import no.digipost.signature.client.direct.DirectJobResponse;
import no.digipost.signature.client.direct.DirectJobStatusResponse;
import no.digipost.signature.client.direct.JaxbEntityMapping;
import no.digipost.signature.client.direct.StatusReference;

public class DirectClient {
    private final ClientHelper client;
    private final CreateASiCE<DirectJob> aSiCECreator;

    public DirectClient(ClientConfiguration config) {
        this.client = new ClientHelper(SignatureHttpClientFactory.create(config), config.getGlobalSender());
        this.aSiCECreator = new CreateASiCE<DirectJob>(new CreateDirectManifest(), config);
    }

    public DirectJobResponse create(DirectJob job) {
        DocumentBundle documentBundle = this.aSiCECreator.createASiCE(job);
        XMLDirectSignatureJobRequest signatureJobRequest = JaxbEntityMapping.toJaxb(job);
        XMLDirectSignatureJobResponse xmlSignatureJobResponse = this.client.sendSignatureJobRequest(signatureJobRequest, documentBundle, job.getSender());
        return JaxbEntityMapping.fromJaxb(xmlSignatureJobResponse);
    }

    public DirectJobStatusResponse getStatus(StatusReference statusReference) {
        XMLDirectSignatureJobStatusResponse xmlSignatureJobStatusResponse = this.client.sendSignatureJobStatusRequest(statusReference.getStatusUrl());
        return JaxbEntityMapping.fromJaxb(xmlSignatureJobStatusResponse);
    }

    public DirectJobStatusResponse getStatusChange() {
        return this.getStatusChange(null);
    }

    public DirectJobStatusResponse getStatusChange(Sender sender) {
        XMLDirectSignatureJobStatusResponse statusChange = this.client.getDirectStatusChange(Optional.ofNullable(sender));
        return statusChange == null ? DirectJobStatusResponse.NO_UPDATED_STATUS : JaxbEntityMapping.fromJaxb(statusChange);
    }

    public void confirm(DirectJobStatusResponse receivedStatusResponse) {
        this.client.confirm(receivedStatusResponse);
    }

    public InputStream getXAdES(XAdESReference xAdESReference) {
        return this.client.getSignedDocumentStream(xAdESReference.getxAdESUrl());
    }

    public InputStream getPAdES(PAdESReference pAdESReference) {
        return this.client.getSignedDocumentStream(pAdESReference.getpAdESUrl());
    }
}

