/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.util.List;
import no.digipost.signature.api.xml.XMLSignerSpecificUrl;

public class RedirectUrls {
    private List<RedirectUrl> urls;

    RedirectUrls(List<RedirectUrl> urls) {
        this.urls = urls;
    }

    String getSingleRedirectUrl() {
        if (this.urls.size() != 1) {
            throw new IllegalStateException("Calls to this method should only be done when there are no more than one (1) redirect URL.");
        }
        return this.urls.get(0).getUrl();
    }

    public String getFor(String personalIdentificationNumber) {
        for (RedirectUrl redirectUrl : this.urls) {
            if (!redirectUrl.signer.equals(personalIdentificationNumber)) continue;
            return redirectUrl.url;
        }
        throw new IllegalArgumentException("Unable to find redirect URL for this signer");
    }

    public List<RedirectUrl> getAll() {
        return this.urls;
    }

    public static class RedirectUrl {
        private final String signer;
        private final String url;

        private RedirectUrl(String signer, String url) {
            this.signer = signer;
            this.url = url;
        }

        static RedirectUrl fromJaxb(XMLSignerSpecificUrl xmlSignerSpecificUrl) {
            return new RedirectUrl(xmlSignerSpecificUrl.getSigner(), xmlSignerSpecificUrl.getValue());
        }

        public String getSigner() {
            return this.signer;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

