/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import java.io.InputStream;
import java.util.Optional;
import no.digipost.signature.api.xml.XMLPortalSignatureJobRequest;
import no.digipost.signature.api.xml.XMLPortalSignatureJobResponse;
import no.digipost.signature.api.xml.XMLPortalSignatureJobStatusChangeResponse;
import no.digipost.signature.client.ClientConfiguration;
import no.digipost.signature.client.asice.CreateASiCE;
import no.digipost.signature.client.asice.DocumentBundle;
import no.digipost.signature.client.asice.manifest.CreatePortalManifest;
import no.digipost.signature.client.core.PAdESReference;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.XAdESReference;
import no.digipost.signature.client.core.internal.Cancellable;
import no.digipost.signature.client.core.internal.ClientHelper;
import no.digipost.signature.client.core.internal.http.SignatureHttpClientFactory;
import no.digipost.signature.client.portal.JaxbEntityMapping;
import no.digipost.signature.client.portal.PortalJob;
import no.digipost.signature.client.portal.PortalJobResponse;
import no.digipost.signature.client.portal.PortalJobStatusChanged;

public class PortalClient {
    private final ClientHelper client;
    private final CreateASiCE<PortalJob> aSiCECreator;

    public PortalClient(ClientConfiguration config) {
        this.client = new ClientHelper(SignatureHttpClientFactory.create(config), config.getGlobalSender());
        this.aSiCECreator = new CreateASiCE<PortalJob>(new CreatePortalManifest(config.getClock()), config);
    }

    public PortalJobResponse create(PortalJob job) {
        DocumentBundle documentBundle = this.aSiCECreator.createASiCE(job);
        XMLPortalSignatureJobRequest signatureJobRequest = JaxbEntityMapping.toJaxb(job);
        XMLPortalSignatureJobResponse xmlPortalSignatureJobResponse = this.client.sendPortalSignatureJobRequest(signatureJobRequest, documentBundle, job.getSender());
        return JaxbEntityMapping.fromJaxb(xmlPortalSignatureJobResponse);
    }

    public PortalJobStatusChanged getStatusChange() {
        return this.getStatusChange(null);
    }

    public PortalJobStatusChanged getStatusChange(Sender sender) {
        XMLPortalSignatureJobStatusChangeResponse statusChange = this.client.getPortalStatusChange(Optional.ofNullable(sender));
        return statusChange == null ? PortalJobStatusChanged.NO_UPDATED_STATUS : JaxbEntityMapping.fromJaxb(statusChange);
    }

    public void confirm(PortalJobStatusChanged receivedStatusChanged) {
        this.client.confirm(receivedStatusChanged);
    }

    public void cancel(Cancellable cancellable) {
        this.client.cancel(cancellable);
    }

    public InputStream getXAdES(XAdESReference xAdESReference) {
        return this.client.getSignedDocumentStream(xAdESReference.getxAdESUrl());
    }

    public InputStream getPAdES(PAdESReference pAdESReference) {
        return this.client.getSignedDocumentStream(pAdESReference.getpAdESUrl());
    }
}

