/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import no.digipost.signature.api.xml.XMLSignatureStatus;

public final class SignatureStatus {
    public static final SignatureStatus REJECTED = new SignatureStatus("REJECTED");
    public static final SignatureStatus CANCELLED = new SignatureStatus("CANCELLED");
    public static final SignatureStatus RESERVED = new SignatureStatus("RESERVED");
    public static final SignatureStatus CONTACT_INFORMATION_MISSING = new SignatureStatus("CONTACT_INFORMATION_MISSING");
    public static final SignatureStatus EXPIRED = new SignatureStatus("EXPIRED");
    public static final SignatureStatus WAITING = new SignatureStatus("WAITING");
    public static final SignatureStatus SIGNED = new SignatureStatus("SIGNED");
    public static final SignatureStatus NOT_APPLICABLE = new SignatureStatus("NOT_APPLICABLE");
    public static final SignatureStatus BLOCKED = new SignatureStatus("BLOCKED");
    public static final SignatureStatus SIGNERS_NAME_NOT_AVAILABLE = new SignatureStatus("SIGNERS_NAME_NOT_AVAILABLE");
    private static final List<SignatureStatus> KNOWN_STATUSES = Arrays.asList(REJECTED, CANCELLED, RESERVED, CONTACT_INFORMATION_MISSING, EXPIRED, WAITING, SIGNED, NOT_APPLICABLE, BLOCKED, SIGNERS_NAME_NOT_AVAILABLE);
    private final String identifier;

    public SignatureStatus(String identifier) {
        this.identifier = identifier;
    }

    static SignatureStatus fromXmlType(XMLSignatureStatus xmlSignatureStatus) {
        String value = xmlSignatureStatus.getValue();
        for (SignatureStatus status : KNOWN_STATUSES) {
            if (!status.is(value)) continue;
            return status;
        }
        return new SignatureStatus(value);
    }

    private boolean is(String xmlSignatureStatus) {
        return this.identifier.equals(xmlSignatureStatus);
    }

    public boolean equals(Object o) {
        if (o instanceof SignatureStatus) {
            SignatureStatus that = (SignatureStatus)o;
            return Objects.equals(this.identifier, that.identifier);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public String toString() {
        return this.identifier;
    }
}

