/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.security;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import no.digipost.signature.client.core.exceptions.CertificateException;
import no.digipost.signature.client.core.exceptions.KeyException;

public class KeyStoreConfig {
    public final KeyStore keyStore;
    public final String alias;
    public final String keystorePassword;
    public final String privatekeyPassword;

    public KeyStoreConfig(KeyStore keyStore, String alias, String keystorePassword, String privatekeyPassword) {
        this.keyStore = keyStore;
        this.alias = alias;
        this.keystorePassword = keystorePassword;
        this.privatekeyPassword = privatekeyPassword;
    }

    public Certificate[] getCertificateChain() {
        try {
            return this.keyStore.getCertificateChain(this.alias);
        }
        catch (KeyStoreException e) {
            throw new KeyException("Failed to retrieve certificate chain from key store. Is key store initialized?", e);
        }
    }

    public X509Certificate getCertificate() {
        Certificate certificate;
        try {
            certificate = this.keyStore.getCertificate(this.alias);
        }
        catch (KeyStoreException e) {
            throw new CertificateException("Failed to retrieve certificate from key store. Is key store initialized?", e);
        }
        if (certificate == null) {
            throw new CertificateException("Failed to find certificate in key store. Are you sure a key store with a certificate is supplied and that you've given the right alias?");
        }
        if (!(certificate instanceof X509Certificate)) {
            throw new CertificateException("Only X509 certificates are supported. Got a certificate with type " + certificate.getClass().getSimpleName());
        }
        this.verifyCorrectAliasCasing(certificate);
        return (X509Certificate)certificate;
    }

    public PrivateKey getPrivateKey() {
        try {
            Key key = this.keyStore.getKey(this.alias, this.privatekeyPassword.toCharArray());
            if (!(key instanceof PrivateKey)) {
                throw new KeyException("Failed to retrieve private key from key store. Expected a PriveteKey, got " + key.getClass().getCanonicalName());
            }
            return (PrivateKey)key;
        }
        catch (KeyStoreException e) {
            throw new KeyException("Failed to retrieve private key from key store. Is key store initialized?", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyException("Failed to retrieve private key from key store. Verify that the key is supported on the platform.", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new KeyException("Failed to retrieve private key from key store. Verify that the password is correct.", e);
        }
    }

    public static KeyStoreConfig fromKeyStore(InputStream keyStore, String alias, String keyStorePassword, String privatekeyPassword) {
        try {
            KeyStore ks = KeyStore.getInstance("JCEKS");
            ks.load(keyStore, keyStorePassword.toCharArray());
            return new KeyStoreConfig(ks, alias, keyStorePassword, privatekeyPassword);
        }
        catch (FileNotFoundException e) {
            throw new KeyException("Failed to initialize key store. Are you sure the file exists?", e);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | java.security.cert.CertificateException e) {
            throw new KeyException("Failed to initialize key store", e);
        }
    }

    private void verifyCorrectAliasCasing(Certificate certificate) {
        try {
            String aliasFromKeystore = this.keyStore.getCertificateAlias(certificate);
            if (!aliasFromKeystore.equals(this.alias)) {
                throw new CertificateException("Certificate alias in keystore was not same as provided alias. Probably different casing. In keystore: " + aliasFromKeystore + ", from config: " + this.alias);
            }
        }
        catch (KeyStoreException e) {
            throw new CertificateException("Unable to get certificate alias based on certificate. This should never happen, as we just read the certificate from the same keystore.", e);
        }
    }
}

