/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.dropwizard;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigSyntax;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.YamlConfigurationFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeSafeConfigurationFactory<T>
extends YamlConfigurationFactory<T> {
    public static final String ENV_KEY = "env";
    public static final String SECRET_KEY = "secret";
    public static final String ENVIRONMENTS_CONFIG_KEY = "environments";
    private static final Logger log = LoggerFactory.getLogger(TypeSafeConfigurationFactory.class);
    private final ObjectMapper mapper;
    private final YAMLFactory yamlFactory;
    private final String propertyPrefix;

    public TypeSafeConfigurationFactory(Class<T> klass, Validator validator, ObjectMapper mapper, String propertyPrefix) {
        super(klass, validator, mapper, propertyPrefix);
        this.propertyPrefix = propertyPrefix.endsWith(".") ? propertyPrefix : propertyPrefix + '.';
        this.mapper = mapper;
        this.yamlFactory = new YAMLFactory();
    }

    public T build(ConfigurationSourceProvider sourceProvider, String path) throws IOException, ConfigurationException {
        Config loaded = this.loadConfig(sourceProvider, path);
        Config config = loaded.resolveWith(ConfigFactory.defaultOverrides(), ConfigResolveOptions.defaults().setAllowUnresolved(true));
        List<String> environments = TypeSafeConfigurationFactory.firstAvailableSystemProperty(ENV_KEY, this.propertyPrefix + ENV_KEY).map(commaSeparatedEnvs -> Stream.of(commaSeparatedEnvs.split(",\\s?"))).orElseThrow(() -> new RuntimeException("System.property env is required and must have a corresponding section in the config file. Example: -Denv=local")).collect(Collectors.toList());
        Config envSpecificConfig = TypeSafeConfigurationFactory.reduceToEnvironmentSpecific(environments, config);
        Config configWithSecrets = TypeSafeConfigurationFactory.firstAvailableSystemProperty(SECRET_KEY).map(secretsPath -> this.loadConfig(sourceProvider, (String)secretsPath)).map(secretsConfig -> TypeSafeConfigurationFactory.reduceToEnvironmentSpecific(environments, secretsConfig).withFallback((ConfigMergeable)envSpecificConfig)).orElse(envSpecificConfig);
        ConfigObject rootConfigObject = configWithSecrets.resolve().withoutPath("variables").root();
        this.logConfig(configWithSecrets, rootConfigObject);
        String configJsonString = rootConfigObject.render(ConfigRenderOptions.concise());
        return (T)super.build(str -> new ByteArrayInputStream(configJsonString.getBytes(StandardCharsets.UTF_8)), path);
    }

    private Config loadConfig(ConfigurationSourceProvider sourceProvider, String path) {
        Config config;
        block8: {
            InputStream source = sourceProvider.open(path);
            try {
                Config config2 = config = path.endsWith(".yml") ? this.loadYamlConfig(source) : this.loadConfig(source);
                if (source == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load config from '" + path + "', because " + e.getClass().getSimpleName() + ": '" + e.getMessage() + "'", e);
                }
            }
            source.close();
        }
        return config;
    }

    private Config loadConfig(InputStream input) {
        InputStreamReader inputReader = new InputStreamReader(input, StandardCharsets.UTF_8);
        return ConfigFactory.parseReader((Reader)inputReader, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false));
    }

    private Config loadYamlConfig(InputStream input) throws IOException {
        JsonNode node = (JsonNode)this.mapper.readTree((JsonParser)this.yamlFactory.createParser(input));
        String jsonString = this.mapper.writeValueAsString((Object)node);
        Config preConfig = ConfigFactory.parseString((String)jsonString, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false));
        String render = preConfig.root().render(ConfigRenderOptions.defaults().setJson(false));
        return ConfigFactory.parseString((String)render.replaceAll("=\\s?\"([^$]?\\$.*?)\"", "=$1"), (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF));
    }

    private void logConfig(Config finalConfig, ConfigObject rootConfigObject) {
        String configFactoryLogKey = "logging.loggers.\"" + ((Object)((Object)this)).getClass().getName() + "\"";
        if (finalConfig.hasPath(configFactoryLogKey) && finalConfig.getString(configFactoryLogKey).equalsIgnoreCase("debug")) {
            log.debug(rootConfigObject.render(ConfigRenderOptions.defaults().setComments(true).setOriginComments(false)));
        }
    }

    private static Optional<String> firstAvailableSystemProperty(String ... propertyNames) {
        return Stream.of(propertyNames).map(System::getProperty).filter(property -> property != null && !property.isEmpty()).findFirst();
    }

    private static Config reduceToEnvironmentSpecific(List<String> environments, Config config) {
        Config envConfig = environments.stream().map(environment -> "environments." + environment).filter(environmentKey -> config.hasPath(environmentKey)).map(environmentKey -> config.getConfig(environmentKey)).reduce(ConfigFactory.empty(), Config::withFallback);
        return envConfig.withFallback((ConfigMergeable)config).withoutPath(ENVIRONMENTS_CONFIG_KEY);
    }
}

