/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.dropwizard.configuration;

import io.dropwizard.configuration.ConfigurationSourceProvider;
import java.io.IOException;
import java.io.InputStream;
import no.digipost.dropwizard.configuration.ConfigurationSourceNotFoundException;

public class ConfigurationSourceProviderWithFallback
implements ConfigurationSourceProvider {
    private final ConfigurationSourceProvider main;
    private final ConfigurationSourceProvider fallback;

    public ConfigurationSourceProviderWithFallback(ConfigurationSourceProvider main, ConfigurationSourceProvider fallback) {
        this.main = main;
        this.fallback = fallback;
    }

    public final InputStream open(String path) throws IOException {
        try {
            return this.main.open(path);
        }
        catch (IOException exceptionOnMainProvider) {
            try {
                return this.fallback.open(path);
            }
            catch (IOException exceptionOnFallbackProvider) {
                ConfigurationSourceNotFoundException e = new ConfigurationSourceNotFoundException("No " + ConfigurationSourceProvider.class.getSimpleName() + " were able to resolve configuration from " + path + ", because " + exceptionOnMainProvider.getMessage() + ", and " + exceptionOnFallbackProvider.getMessage(), exceptionOnMainProvider);
                e.addSuppressed(exceptionOnFallbackProvider);
                throw e;
            }
            catch (RuntimeException e) {
                e.addSuppressed(exceptionOnMainProvider);
                throw e;
            }
        }
    }
}

