/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JsonDuration
implements TemporalAmount,
Serializable {
    public static final List<ChronoUnit> supportedUnits = Collections.unmodifiableList(Stream.of(ChronoUnit.values()).filter(u -> !u.isDurationEstimated() || u == ChronoUnit.DAYS).collect(Collectors.toList()));
    public final long amount;
    public final TemporalUnit unit;
    public final Duration duration;
    private final String stringRepresentation;

    @JsonCreator
    public static JsonDuration of(String jsonString) {
        return new JsonDuration(jsonString);
    }

    private JsonDuration(String jsonString) {
        try {
            String[] amountAndUnit = jsonString.split("\\s+");
            this.amount = Long.parseLong(amountAndUnit[0]);
            ChronoUnit chronoUnit = ChronoUnit.valueOf(amountAndUnit[1].toUpperCase());
            this.unit = chronoUnit;
            this.duration = Duration.of(this.amount, this.unit);
            this.stringRepresentation = this.amount + " " + chronoUnit.name();
        }
        catch (Exception e) {
            throw new CannotConvertToJsonDuration(jsonString, e);
        }
    }

    @JsonValue
    public String toString() {
        return this.stringRepresentation;
    }

    @Override
    public long get(TemporalUnit unit) {
        return this.duration.get(unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return this.duration.getUnits();
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return this.duration.addTo(temporal);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return this.duration.subtractFrom(temporal);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JsonDuration) {
            JsonDuration that = (JsonDuration)obj;
            return Objects.equals(this.duration, that.duration);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.duration);
    }

    public static class CannotConvertToJsonDuration
    extends RuntimeException {
        public CannotConvertToJsonDuration(String jsonString, Throwable cause) {
            super("Unable to convert \"" + jsonString + "\" to " + JsonDuration.class.getSimpleName() + " because " + cause.getClass().getSimpleName() + ": '" + cause.getMessage() + "'. String must be on the form \"<amount> <unit>\", where the unit is one of " + supportedUnits.stream().map(Enum::name).collect(Collectors.joining(", ")) + " (case-insensitive)");
        }
    }
}

