/*
 * Decompiled with CFR 0.152.
 */
package no.entur.protoc.interfaces;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLiteOrBuilder;
import com.google.protobuf.compiler.PluginProtos;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import no.entur.protoc.interfaces.InterfaceProtocContext;
import org.apache.commons.lang3.StringUtils;
import xsd.Xsd;

public class MessageTypeHandler {
    private static final String JAVA_EXTENSION = ".java";
    private final InterfaceProtocContext context;
    private final DescriptorProtos.DescriptorProto messageTypeDesc;
    private final DescriptorProtos.FileDescriptorProto fileDesc;
    private String protoFullPath;
    private String javaPackageName;
    private String interfaceFullName;
    private String builderInterfaceFullName;
    private String baseTypeFullPath;

    public MessageTypeHandler(InterfaceProtocContext context, DescriptorProtos.DescriptorProto messageTypeDesc, DescriptorProtos.FileDescriptorProto fileDesc) {
        this.context = context;
        this.messageTypeDesc = messageTypeDesc;
        this.fileDesc = fileDesc;
        this.init();
    }

    private void init() {
        this.protoFullPath = this.fileDesc.getPackage() + "." + this.messageTypeDesc.getName();
        this.javaPackageName = this.getJavaPackageName(this.fileDesc.getPackage(), this.messageTypeDesc.getName());
        this.interfaceFullName = this.javaPackageName + "." + this.getInterfaceName();
        this.builderInterfaceFullName = this.javaPackageName + "." + this.getBuilderInterfaceName(this.messageTypeDesc);
        String baseTypeOptionalsVal = this.messageTypeDesc.getOptions().getExtension(Xsd.baseType);
        if (!StringUtils.isEmpty(baseTypeOptionalsVal) && !baseTypeOptionalsVal.contains(".")) {
            baseTypeOptionalsVal = this.fileDesc.getPackage() + "." + baseTypeOptionalsVal;
        }
        this.baseTypeFullPath = baseTypeOptionalsVal;
    }

    private boolean hasBaseType() {
        return !StringUtils.isEmpty(this.baseTypeFullPath) && !StringUtils.isEmpty(this.getBaseTypeJavaPackageName());
    }

    public void generateInterfaces() {
        this.createInterface();
        this.createBuilderInterface();
    }

    public List<PluginProtos.CodeGeneratorResponse.File> generateAddInterfaceCodeGenerationFiles() {
        ArrayList<PluginProtos.CodeGeneratorResponse.File> files = new ArrayList<PluginProtos.CodeGeneratorResponse.File>();
        files.add(PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(this.getCodeGeneratorFileName()).setInsertionPoint("message_implements:" + this.protoFullPath).setContent(this.interfaceFullName + ",").build());
        files.add(PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(this.getCodeGeneratorFileName()).setInsertionPoint("builder_implements:" + this.protoFullPath).setContent(this.builderInterfaceFullName + ",").build());
        return files;
    }

    private List<DescriptorProtos.FieldDescriptorProto> getInterfaceFields(boolean includeInnerFields) {
        Set<String> baseTypeFields = this.getBaseTypeFields();
        return this.messageTypeDesc.getFieldList().stream().filter(field -> includeInnerFields || !this.isInnerMessage(field.getTypeName())).filter(field -> !baseTypeFields.contains(field.getName()) || this.isInnerMessage(field.getTypeName())).collect(Collectors.toList());
    }

    private boolean isInnerMessage(String typeName) {
        return typeName.startsWith("." + this.protoFullPath + ".");
    }

    private Set<String> getBaseTypeFields() {
        DescriptorProtos.DescriptorProto baseTypeDesc = this.context.baseTypes.get(this.baseTypeFullPath);
        if (baseTypeDesc != null) {
            return baseTypeDesc.getFieldList().stream().map(DescriptorProtos.FieldDescriptorProto::getName).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private void createBuilderInterface() {
        TypeName baseType;
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        String builderInterfaceName = this.getBuilderInterfaceName(this.messageTypeDesc);
        ClassName builderInterfaceTypeName = ClassName.get(this.javaPackageName, builderInterfaceName, new String[0]);
        for (DescriptorProtos.FieldDescriptorProto field : this.getInterfaceFields(false)) {
            String fieldAsCamelCase = this.toPascalCase(field.getName());
            TypeName type = this.mapType(field, false);
            if (field.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED) {
                TypeName typeArgument = this.getSetterListTypeArgument(field, type);
                ParameterizedTypeName repeatedType = ParameterizedTypeName.get(ClassName.get(Iterable.class), typeArgument);
                MethodSpec getMethod = MethodSpec.methodBuilder("addAll" + fieldAsCamelCase).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).addParameter(repeatedType, "values", new Modifier[0]).returns(builderInterfaceTypeName).build();
                methods.add(getMethod);
                continue;
            }
            MethodSpec setMethod = MethodSpec.methodBuilder("set" + fieldAsCamelCase).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).addParameter(type, "value", new Modifier[0]).returns(builderInterfaceTypeName).build();
            methods.add(setMethod);
        }
        ClassName interfaceClassName = ClassName.get(this.javaPackageName, this.getInterfaceName(), new String[0]);
        MethodSpec buildMethod = MethodSpec.methodBuilder("build").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(interfaceClassName).build();
        methods.add(buildMethod);
        if (this.hasBaseType()) {
            String baseTypeBuilderInterfaceName = this.getBuilderInterfaceName(this.getBaseTypeMessageName());
            baseType = this.getBaseType(baseTypeBuilderInterfaceName);
        } else {
            baseType = ClassName.get(MessageLiteOrBuilder.class);
        }
        this.writeInterface(builderInterfaceName, methods, baseType);
    }

    private TypeName getBaseType(String baseTypeInterfaceName) {
        String baseTypeJavaPackageName = this.getBaseTypeJavaPackageName();
        return ClassName.get(baseTypeJavaPackageName, baseTypeInterfaceName, new String[0]);
    }

    private void createInterface() {
        TypeName baseType;
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        for (DescriptorProtos.FieldDescriptorProto field : this.getInterfaceFields(true)) {
            String fieldAsCamelCase = this.toPascalCase(field.getName());
            TypeName type = this.mapType(field, this.context.useInterfacesForLocalReturnTypes);
            if (field.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED) {
                if (this.isMapEntry(field)) continue;
                TypeName typeArgument = this.getGetterListTypeArgument(field, type);
                ParameterizedTypeName listType = ParameterizedTypeName.get(ClassName.get(List.class), typeArgument);
                MethodSpec getMethod = MethodSpec.methodBuilder("get" + fieldAsCamelCase + "List").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(listType).build();
                methods.add(getMethod);
                continue;
            }
            TypeName returnType = this.isInnerTypeInBaseType(field) ? ClassName.get(MessageLite.class) : type;
            MethodSpec getMethod = MethodSpec.methodBuilder("get" + fieldAsCamelCase).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(returnType).build();
            methods.add(getMethod);
            if (field.getType() != DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE) continue;
            MethodSpec hasMethod = MethodSpec.methodBuilder("has" + fieldAsCamelCase).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(Boolean.TYPE).build();
            methods.add(hasMethod);
        }
        String interfaceName = this.getInterfaceName();
        if (this.hasBaseType()) {
            String baseTypeInterfaceName = this.getInterfaceName(this.getBaseTypeMessageName());
            baseType = this.getBaseType(baseTypeInterfaceName);
        } else {
            baseType = ClassName.get(MessageLite.class);
        }
        this.writeInterface(interfaceName, methods, baseType);
    }

    private boolean isMapEntry(DescriptorProtos.FieldDescriptorProto field) {
        return this.isInnerMessage(field.getTypeName()) && field.getTypeName().endsWith("Entry");
    }

    private boolean isInnerTypeInBaseType(DescriptorProtos.FieldDescriptorProto field) {
        return this.isInnerMessage(field.getTypeName()) && field.getType() == DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE && this.context.baseTypes.containsKey(this.protoFullPath);
    }

    private void writeInterface(String interfaceName, List<MethodSpec> methods, TypeName baseType) {
        TypeSpec.Builder typeSpec = TypeSpec.interfaceBuilder(interfaceName).addModifiers(Modifier.PUBLIC).addMethods(methods);
        if (baseType != null) {
            typeSpec.addSuperinterface(baseType);
        }
        JavaFile javaFile = JavaFile.builder(this.javaPackageName, typeSpec.build()).build();
        try {
            javaFile.writeTo(new File(this.context.targetFolder));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private TypeName mapType(DescriptorProtos.FieldDescriptorProto field, boolean useInterfaceForLocalTypes) {
        switch (field.getType()) {
            case TYPE_DOUBLE: {
                return TypeName.DOUBLE;
            }
            case TYPE_FLOAT: {
                return TypeName.FLOAT;
            }
            case TYPE_SFIXED64: 
            case TYPE_SINT64: 
            case TYPE_INT64: 
            case TYPE_UINT64: 
            case TYPE_FIXED64: {
                return TypeName.LONG;
            }
            case TYPE_UINT32: 
            case TYPE_INT32: 
            case TYPE_FIXED32: 
            case TYPE_SFIXED32: 
            case TYPE_SINT32: {
                return TypeName.INT;
            }
            case TYPE_BOOL: {
                return TypeName.BOOLEAN;
            }
            case TYPE_STRING: {
                return ClassName.get(String.class);
            }
            case TYPE_BYTES: {
                return ClassName.get(ByteString.class);
            }
            case TYPE_MESSAGE: {
                return this.getClassNameFromTypeName(field.getTypeName(), useInterfaceForLocalTypes);
            }
            case TYPE_ENUM: {
                return this.getClassNameFromTypeName(field.getTypeName(), false);
            }
        }
        throw new IllegalArgumentException("Unable to map unknown type: " + field.getType());
    }

    public ClassName getClassNameFromTypeName(String typeName, boolean useInterfaceForLocalTypes) {
        String[] parts = typeName.split("\\.");
        String className = parts[parts.length - 1];
        String packageName = this.getJavaPackageName(typeName);
        if (useInterfaceForLocalTypes && this.context.isGeneratedType(typeName)) {
            className = className + "I";
        }
        return ClassName.get(packageName, className, new String[0]);
    }

    private TypeName getSetterListTypeArgument(DescriptorProtos.FieldDescriptorProto field, TypeName type) {
        boolean useWildcardGenericType = DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING != field.getType();
        TypeName typeArgument = useWildcardGenericType ? WildcardTypeName.subtypeOf(type.box()) : type;
        return typeArgument;
    }

    private TypeName getGetterListTypeArgument(DescriptorProtos.FieldDescriptorProto field, TypeName type) {
        boolean useWildcardGenericType = this.context.useInterfacesForLocalReturnTypes;
        TypeName typeArgument = this.isInnerTypeInBaseType(field) ? WildcardTypeName.subtypeOf(ClassName.get(MessageLite.class)) : (useWildcardGenericType ? WildcardTypeName.subtypeOf(type.box()) : (type.isPrimitive() ? type.box() : type));
        return typeArgument;
    }

    private boolean isInterfacedField(DescriptorProtos.FieldDescriptorProto field) {
        return field.getType() == DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE && this.context.isGeneratedType(field.getTypeName());
    }

    private String getJavaPackageName(String packageName, String messageName) {
        return this.getJavaPackageName("." + packageName + "." + messageName);
    }

    private String getJavaPackageName(String fullTypeName) {
        String javaTypeName = this.context.protoTypeMap.toJavaTypeName(fullTypeName);
        if (javaTypeName != null) {
            String[] parts = javaTypeName.split("\\.");
            String className = parts[parts.length - 1];
            String packageName = javaTypeName.replace("." + className, "");
            if (packageName.startsWith(".")) {
                packageName = packageName.substring(1);
            }
            return packageName;
        }
        return null;
    }

    private String getInterfaceName() {
        return this.getInterfaceName(this.messageTypeDesc.getName());
    }

    private String getInterfaceName(String messageName) {
        return messageName + "I";
    }

    private String getBuilderInterfaceName(DescriptorProtos.DescriptorProto messageTypeDesc) {
        return this.getBuilderInterfaceName(messageTypeDesc.getName());
    }

    private String getBuilderInterfaceName(String messageName) {
        return messageName + "BuilderI";
    }

    private String toPascalCase(String snakeCaseString) {
        StringBuilder sb = new StringBuilder(snakeCaseString);
        sb.replace(0, 1, String.valueOf(Character.toUpperCase(sb.charAt(0))));
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '_') continue;
            sb.deleteCharAt(i);
            sb.replace(i, i + 1, String.valueOf(Character.toUpperCase(sb.charAt(i))));
        }
        return sb.toString();
    }

    private String getCodeGeneratorFileName() {
        String javaPackage = this.fileDesc.getOptions().hasJavaPackage() ? this.fileDesc.getOptions().getJavaPackage() : this.fileDesc.getPackage();
        return javaPackage.replace(".", "/") + "/" + this.messageTypeDesc.getName() + JAVA_EXTENSION;
    }

    private String getBaseTypeJavaPackageName() {
        return this.getJavaPackageName("." + this.baseTypeFullPath);
    }

    private String getBaseTypeMessageName() {
        String[] parts = this.baseTypeFullPath.split("\\.");
        return parts[parts.length - 1];
    }
}

